% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{kmerPeaks}
\alias{kmerPeaks}
\title{Call k-mer peaks}
\usage{
kmerPeaks(sarks, filters, thresholds, peakify = TRUE, kMax = 12L)
}
\arguments{
\item{sarks}{Sarks object to use for k-mer peak calling.}

\item{filters}{output from sarksFilters function indicating what
combinations of filter parameters halfWindow, spatialLength,
and minGini to use.}

\item{thresholds}{output from permutationThresholds specifying
thresholds for k-mer peak calling.}

\item{peakify}{logical value specifying whether to restrict output
to only spatial positions at which the smoothed score is at
least as high as either neighboring position or not.}

\item{kMax}{integer value indicating the maximum k-mer length to be
reported.}
}
\value{
data.frame containing called k-mer peak information.
}
\description{
SArKS identifies sets of short subsequences (k-mers) whose presence
as substrings of sequences from the input sequence set tends to be
associated with elevated sequence scores. Such k-mers are
identified as ``peaks'' where kernel-smoothed scores exceed
specified thresholds (generally set by permutation method).
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=2.0)
peaks <- kmerPeaks(sarks, filters, thresholds)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
