% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{estimateFalsePositiveRate}
\alias{estimateFalsePositiveRate}
\title{Estimating SArKS false positive rate}
\usage{
estimateFalsePositiveRate(sarks, reps, filters, thresholds, seed = NULL,
    conf.level = 0.95)
}
\arguments{
\item{sarks}{Sarks object to test.}

\item{reps}{integer specifying how many repetitions to test.}

\item{filters}{output from sarksFilters function indicating what
combinations of filter parameters halfWindow, spatialLength,
and minGini to use.}

\item{thresholds}{output from permutationThresholds specifying
thresholds for k-mer peak calling.}

\item{seed}{optional seed for random number generator (use in case
    reproducibility of output is desired).

    NOTE: do not use the same seed passed to initial
    permutationDistribution call used to set thresholds.}

\item{conf.level}{level of confidence to be used in the false
positive rate confidence interval.}
}
\value{
named list with three elements: `permutation' containing
the output from permutationDistribution run.
}
\description{
Run second permutation test using the specified number of
repetitions, keeping track of maximum observed windowed and
spatially-windowed smoothed scores for each combination of filter
parameters for each permutation, and comparing these values to
thresholds determined by first round of permutation testing.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=0, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=2.0)
fpr <- estimateFalsePositiveRate(
        sarks, 250, filters, thresholds, seed=123456)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
