% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{blockScores}
\alias{blockScores}
\title{SArKS input scores}
\usage{
blockScores(sarks)
}
\arguments{
\item{sarks}{Sarks object from which information will be derived}
}
\value{
named numeric vector; names are the sequence names, values
    are the associated scores. Note: Sarks internally sorts input
    lexicographically by sequence name.
}
\description{
Extracts vector of input scores associated with input sequences
from sarks object.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
simulatedScores2 <- blockScores(sarks)
## simulatedScores2 will be in different order than simulatedScores,
## but contains same information.

}
