% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{Sarks}
\alias{Sarks}
\title{Suffix Array Kernel Smoothing}
\usage{
Sarks(fasta, scores, halfWindow, spatialLength = 0L, nThreads = 1L)
}
\arguments{
\item{fasta}{specification of fasta file containing sequences to be
analyzed; may also be a *named* character vector or
XStringSet whose elements are sequences to be analyzed.}

\item{scores}{specification of scores associated with sequences in
fasta argument; can be provided as two column tab-delimited
file (should have header, first column should provide sequence
names identical to those in fasta argument, second column
should have numeric scores) or may be a named numeric vector.}

\item{halfWindow}{half-width of smoothing window (integer).}

\item{spatialLength}{full length of spatial smoothing window
(integer); use 0 to disable spatial smoothing.}

\item{nThreads}{number of threads to use for computing permutation
distributions.}
}
\value{
R representation of java Sarks object.
}
\description{
Sarks class implements suffix array kernel smoothing for de novo
correlative motif discovery.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
