% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerRead.R
\name{SangerRead-class-updateQualityParam}
\alias{SangerRead-class-updateQualityParam}
\alias{updateQualityParam,SangerRead-method}
\title{updateQualityParam}
\usage{
\S4method{updateQualityParam}{SangerRead}(
  object,
  TrimmingMethod = "M1",
  M1TrimmingCutoff = 1e-04,
  M2CutoffQualityScore = NULL,
  M2SlidingWindowSize = NULL
)
}
\arguments{
\item{object}{A SangerRead S4 instance.}

\item{TrimmingMethod}{The read trimming method for this SangerRead. The value must be \code{"M1"} (the default) or \code{'M2'}.}

\item{M1TrimmingCutoff}{The trimming cutoff for the Method 1. If \code{TrimmingMethod} is \code{"M1"}, then the default value is \code{0.0001}. Otherwise, the value must be \code{NULL}.}

\item{M2CutoffQualityScore}{The trimming cutoff quality score for the Method 2. If \code{TrimmingMethod} is \code{'M2'}, then the default value is \code{20}. Otherwise, the value must be \code{NULL}. It works with \code{M2SlidingWindowSize}.}

\item{M2SlidingWindowSize}{The trimming sliding window size for the Method 2. If \code{TrimmingMethod} is \code{'M2'}, then the default value is \code{10}. Otherwise, the value must be \code{NULL}. It works with \code{M2CutoffQualityScore}.}
}
\value{
A SangerRead instance.
}
\description{
A SangerRead method which updates QualityReport parameter inside the SangerRead.
}
\examples{
data("sangerReadFData")
updateQualityParam(sangerReadFData,
                   TrimmingMethod         = "M2",
                   M1TrimmingCutoff       = NULL,
                   M2CutoffQualityScore   = 40,
                   M2SlidingWindowSize    = 15)
}
