% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeNormalize}
\alias{sracipeNormalize}
\alias{sracipeNormalize,RacipeSE-method}
\title{Normalize the simulated gene expression}
\usage{
sracipeNormalize(.object)

\S4method{sracipeNormalize}{RacipeSE}(.object)
}
\arguments{
\item{.object}{RacipeSE object}
}
\value{
A RacipeSE object
}
\description{
Normalize the simulated gene expression including gene
expressions for stochastic and knockout simulations
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}},
}

\examples{
data("demoCircuit")
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20,
integrateStepSize = 0.1, simulationTime = 30)
rSet <- sracipeNormalize(rSet)
}
