% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapSimilarity.R
\name{sracipeHeatmapSimilarity}
\alias{sracipeHeatmapSimilarity}
\title{Calculates the similarity between two gene expression data.}
\usage{
sracipeHeatmapSimilarity(
  dataReference,
  dataSimulation,
  clusterCut = NULL,
  nClusters = 3,
  pValue = 0.05,
  permutedVar,
  permutations = 1000,
  corMethod = "spearman",
  clusterMethod = "ward.D2",
  method = "pvalue",
  buffer = 0.001,
  permutMethod = "simulation",
  returnData = FALSE
)
}
\arguments{
\item{dataReference}{Matrix. The reference data matrix, for example, 
the experimental gene expression values}

\item{dataSimulation}{Matrix. The data matrix to be compared.}

\item{clusterCut}{(optional) Integer vector. Clsuter numbers assigned 
to reference data.
If clusterCut is missing, hierarchical clustering using /code{ward.D2}
and /code{distance  = (1-cor(x, method = "spear"))/2} will be used to 
cluster the reference data.}

\item{nClusters}{(optional) Integer. The number of clusters in which the
reference data should be clustered for comparison.
Not needed if clusterCut is provided.}

\item{pValue}{(optional) Numeric. p-value to consider two gene expression
 sets as belonging to same cluster.
Ward's method with spearman correlation is used to determine if a
model belongs to a specific cluster.}

\item{permutedVar}{(optional) Similarity scores computed after permutations.}

\item{permutations}{(optional) Integer. Default \code{1000}.
Number of gene permutations to generate the null distibution.}

\item{corMethod}{(optional) Correlation method. Default method is "spearman".
For single cell data, use "kendall"}

\item{clusterMethod}{(optional) Character - default \code{ward.D2}, other
options include \code{complete}. Clustering method to be used to cluster the
 experimental data. \code{\link[stats]{hclust}} for other options.}

\item{method}{(optional) character. Method to compare the gene expressions.
Default \code{pvalue}. One can use \code{variance} as well which assigns
clusters based on the cluster whose samples have minimum variance with
the simulated sample.}

\item{buffer}{(optional) Numeric. Default \code{0.001}. The fraction of
models to be assigned to clusters to which no samples could be assigned.
For example, a minimum of 1 ghost sample in reference is assigned to
 NULL cluster.}

\item{permutMethod}{"sample" or "reference"}

\item{returnData}{(optional) Logical. Default \code{FALSE}. Whether to
return the sorted and clustered data.}
}
\value{
A list containing the KL distance of new cluster distribution from 
reference data and
the probability of each cluster in the reference and simulated data.
}
\description{
Comparison is done across columns, i.e., 
how similar are the columns in the two dataset.
For gene expression data, format data so that gene names are in rows and 
samples in columns.
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}},
\code{\link{sracipeHeatmapSimilarity}}
}

