% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeCombineRacipeSE}
\alias{sracipeCombineRacipeSE}
\alias{sracipeCombineRacipeSE,list-method}
\title{A method to combine RacipeSE objects with the same config}
\usage{
sracipeCombineRacipeSE(.object)

\S4method{sracipeCombineRacipeSE}{list}(.object)
}
\arguments{
\item{.object}{RacipeSE object generated by \code{\link{sracipeSimulate}}
function.}
}
\value{
\code{RacipeSE} object
}
\description{
It is often the case that to save time, multiple simulations
of the same topology with the same config file are run in parallel. However,
one still wants to condense the results of the different simulations into one
object. This method does that, combining the params, ics, and expressions
of a list of objects into one. If convergence testing is done, convergence
data and unique state counts are combined as well. Limit cycle data is combined
too. The method validates the RacipeSE objects as having essentially identical
configurations compared to the first object provided
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}}
}

\examples{
data("demoCircuit")
\dontrun{
  data(democircuit)
  for(i in 1:5){
    rSet <- sracipeSimulate(demoCircuit, numModels = 100,
                               numConvergenceIter  = 20, nIC = 2)
    racipeList <- c(racipeList, results)
  }

  combinedObject <- sracipeCombineRacipeSE(racipeList)
}
}
