% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_semtypes}
\alias{summarize_semtypes}
\title{Summarize semantic types}
\usage{
summarize_semtypes(graph, object, print = TRUE, is_path = TRUE)
}
\arguments{
\item{graph}{The SemMed graph}

\item{object}{A vertex sequence (\code{igraph.vs}), a list of vertex
sequences, or a list of vertex sequence lists}

\item{print}{If \code{TRUE}, information on semantic types will be 
printed to the screen.}

\item{is_path}{If \code{TRUE}, \code{object} contains paths (ordered 
sequences of nodes).}
}
\value{
Output is returned invisibly.
If \code{is_path = TRUE}, a \code{tbl} where each row corresponds 
to a \code{from}-\code{to} pair in \code{object}. The last column 
is a list-column containing \code{table}'s of semantic type counts.
If \code{is_path = FALSE}, a \code{tbl} where each row corresponds 
to a name-semantic type combination. Columns give node name, 
semantic type, degree, and degree percentile.
}
\description{
Summarize the semantic types present in a collection of nodes
}
\details{
\code{summarize_semtypes} summarizes the semantic types present in 
supplied node collections and has different behavior depending on 
whether the node collection is ordered (paths) or unordered. Using 
\code{is_path = TRUE} indicates that the nodes are ordered. Using 
\code{is_path = FALSE} indicates that the nodes are an unordered 
collection, often from \code{find_nodes} or \code{grow_nodes}.

Using \code{is_path = TRUE}: When the node collection is ordered, the 
object is assumed to be the result of \code{find_paths} or a subset of 
such an object. Because \code{find_paths} returns a list of paths lists, 
\code{summarize_semtypes} takes a single path, a list of paths, or a 
list of path lists as input. In the case of a collection of ordered nodes, 
\code{summarize_semtypes} counts the semantic types present in 
\code{object}. If a node is associated with multiple semantic types, 
each type is counted once. The first and last nodes of each path are 
removed they correspond to the nodes in \code{from} and \code{to} from 
\code{find_paths}, and it is assumed that the middle nodes on the paths 
are more of interest. The tabulations are printed to screen (if 
\code{print = TRUE}) and returned as \code{table}'s. These \code{table}'s 
are bundled into a list-column of a \code{tbl} in the (invisbly returned) 
output. Each row of the \code{tbl} corresponds to a \code{from}-\code{to} 
pair present in \code{object}.

Using \code{is_path = FALSE}: This option is for summarizing results from 
\code{find_nodes} and \code{grow_nodes}, which return unordered node sets.
(Note: paths and unordered node sets are both represented as \code{igraph} 
vertex sequences (class \code{igraph.vs}).) The printed output shows 
information for each semantic type present in \code{object}. It shows all 
nodes of that semantic type as well as their degree and degree percentile 
within the entire \code{graph}. The (invisibly returned) output combines 
all of the printed information in a \code{tbl}.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, "Serum cortisol")
node_stress <- find_nodes(g_mini, "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)
summarize_semtypes(g_mini, paths)

nodes_mood <- find_nodes(g_mini, "mood")
summarize_semtypes(g_mini, nodes_mood, is_path = FALSE)

}
\seealso{
\code{\link{summarize_predicates}} for summarizing 
predicates on edges

\code{\link{find_paths}} for searching for paths 
between node sets

\code{\link{find_nodes}} and \code{\link{grow_nodes}} 
for searching for and filtering nodes
}
