% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_edge_features}
\alias{get_edge_features}
\title{Get information about edges}
\usage{
get_edge_features(
    graph,
    include_degree = FALSE,
    include_node_ids = FALSE,
    include_num_instances = FALSE
)
}
\arguments{
\item{graph}{The SemMed graph}

\item{include_degree}{If \code{TRUE}, include information on head/tail 
node degrees.}

\item{include_node_ids}{If \code{TRUE}, include the ID numbers of 
head/tail nodes.}

\item{include_num_instances}{If \code{TRUE}, include information on the
number of times a predication was observed 
in the Semantic MEDLINE database.}
}
\value{
A \code{tbl} where each row corresponds to an edge in the 
Semantic MEDLINE graph. The ordering of the rows corresponds to
\code{E(graph)}. Features (columns) always returned include the 
name and semantic type of the head (subject) and tail (object) nodes.
}
\description{
Search for nodes by name using regular expressions or which match given 
semantic types. Perform anti-matching by setting \code{match = FALSE}.
}
\examples{
data(g_mini)

e_feat <- get_edge_features(g_mini)

}
\seealso{
\code{\link{make_edge_weights}} for using this data to 
construct edge weights
}
