% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_paths}
\alias{find_paths}
\title{Shortest paths between node sets}
\usage{
find_paths(graph, from, to, weights = NULL)
}
\arguments{
\item{graph}{The SemMed graph}

\item{from}{A set of source nodes. \code{from} should be of class
\code{igraph.vs} (a vertex sequence) or an integer vector.}

\item{to}{A set of destination nodes. \code{to} should be of class
\code{igraph.vs} (a vertex sequence) or an integer vector.}

\item{weights}{A numeric vector of edge weights. If \code{NULL} 
(the default), all edges have the default weight of 1.}
}
\value{
A list of shortest paths. List items correspond to the 
node(s) given in \code{from}.
}
\description{
Find all shortest paths between sets of nodes
}
\details{
\code{find_paths} relies on \code{igraph::all_shortest_paths} to find all 
shortest paths between the nodes in \code{from} and \code{to}. This 
function searches for undirected paths.

Because the Semantic MEDLINE graph is a multigraph, there may be multiple 
paths with the same sequence of nodes. This function collapses these into 
a single node sequence. The display functions (\code{text_path} and
\code{plot_path}) take care of showing the multiple edges leading to 
repeated paths.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, names = "Serum cortisol")
node_stress <- find_nodes(g_mini, names = "Chronic Stress")
find_paths(g_mini, from = node_cortisol, to = node_stress)

}
\seealso{
\code{\link{make_edge_weights}} to tailor the 
shortest path search
}
