% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{rpxCache}
\alias{pxCachedProjects}
\title{Package cache}
\usage{
rpxCache()

pxCachedProjects(cache = rpxCache(), rpxprefix = "^\\\\.rpx(2?)")
}
\arguments{
\item{cache}{Object of class \code{BiocFileCache}.}

\item{rpxprefix}{\code{character(1)} defining the resourne name prefix
in \code{cache}. Default is \code{"^\\\\.rpx(2?)"} to match objects of
class \code{PXDataset} and \code{PXDataset2}.}
}
\value{
The \code{rpxCache()} function returns an instance of class
\code{BiocFileCache}. \code{pxCachedProjects()} invisbly returns a
\code{tibble} of cached ProteomeXchange projects.
}
\description{
Function to access and manage the cache. \code{rxpCache()} returns the
central \code{rpx} cache. \code{pxCachedrojects()} prints the names of the
cached projects and invisibly returns the cache table.
}
\details{
The cache is an object of class \code{BiocFileCache}, and created with
\code{BiocFileCache::BiocFileCache()}. It can be either the
package-wide cache as defined by \code{rpxCache()} or an instaned
provided by the user.

When projects are cached, they are given a resource name (\code{rname})
composed of the \code{.rpx} prefix followed by the ProteomeXchange
identifier. For example, project \code{PXD000001} is named
\code{.rpxPXD000001} (\code{.rpx2PXD000001} for the \code{PXDataset2} class) to
avoid any conflicts with other resources that user-created
resources.
}
\examples{

## Default rpx cache
rpxCache()

\dontrun{

## Set up your own cache by providing a file or a directory to
## BiocFileCache::BiocFileCache()
my_cache <- BiocFileCache::BiocFileCache(tempfile())
my_cache
px <- PXDataset("PXD000001", cache = my_cache)
pxget(px, "erwinia_carotovora.fasta", cache = my_cache)


## List of cached projects
pxCachedProjects() ## default rpx cache
pxCachedProjects(my_cache)

## To delete project a project from the default cache, first find
## its resource id (rid) in the cache
px1_cache_info <- pxCacheInfo(px)
(rid <- px1_cache_info["rid"])

## Then remove it with BiocFileCache:: bfcremove()
BiocFileCache:::bfcremove(my_cache, rid)
pxCachedProjects(my_cache)
}
}
\author{
Laurent Gatto
}
