% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusProfile.R
\name{consensusProfile}
\alias{consensusProfile}
\title{Get sequence information from an alignment}
\usage{
consensusProfile(x, ambiguityThreshold = 0)
}
\arguments{
\item{x}{A \code{Biostrings::DNAMultipleAlignment} object.}

\item{ambiguityThreshold}{"Detection level" for ambiguous bases.
All DNA bases that occur with a relative frequency higher than the
specified value will be included when the IUPAC consensus character
is determined.
Can range from 0 to 0.2, defaults to \code{0}.}
}
\value{
An \code{RprimerProfile} object, which contains the following information:

\describe{
  \item{position}{Position in the alignment.}
  \item{a}{Proportion of A.}
  \item{c}{Proportion of C.}
  \item{g}{Proportion of G.}
  \item{t}{Proportion of T.}
  \item{other}{Proportion of bases other than A, C, G, T.}
  \item{gaps}{Proportion of gaps (recognized as "-" in the alignment).}
  \item{majority}{Majority consensus sequence.
  Denotes the most frequently occurring nucleotide.
  If two or more bases occur with the same frequency,
  the consensus nucleotide will be randomly selected among these.}
  \item{identity}{Proportion of sequences, among all sequences with a
  DNA base (i.e., A, C, G or T), that has the majority consensus base.}
  \item{iupac}{The consensus sequence expressed in IUPAC format.
  The IUPAC consensus sequence only
  takes 'A', 'C', 'G', 'T' and '-' as input. Degenerate bases
  will be skipped. If a position only contains
  degenerate bases, the IUPAC consensus will be \code{NA} at that
  position.}
  \item{coverage}{Proportion of sequences in the target alignment,
  among all sequences with a DNA base, that are covered the IUPAC consensus
  character.
  The value will be 1 if there are no "remaining" DNA bases (and/or if
  \code{ambiguityThreshold = 0}).}
}
}
\description{
\code{consensusProfile()} takes a DNA multiple alignment as input and
returns all the data needed for subsequent primer and probe design process.
The function is a wrapper to
\code{Biostrings::consensusMatrix()} (Pages et al., 2020).
}
\examples{
data("exampleRprimerAlignment")
consensusProfile(exampleRprimerAlignment)

consensusProfile(exampleRprimerAlignment, ambiguityThreshold = 0.05)
}
\references{
Pages, H., Aboyoun, P., Gentleman R., and DebRoy S. (2020). Biostrings:
Efficient manipulation of biological strings. R package version
2.57.2.
}
