% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ontologies.R
\name{olsOntologies}
\alias{olsOntologies}
\alias{olsOntology}
\alias{olsLinks}
\alias{olsLinks,olsOntology}
\alias{olsConfig}
\alias{olsConfig,olsOntology}
\alias{olsVersion}
\alias{olsVersion,character}
\alias{olsVersion,olsOntology}
\alias{olsVersion,olsOntologies}
\alias{olsLoaded}
\alias{olsLoaded,character}
\alias{olsLoaded,olsOntology}
\alias{olsLoaded,olsOntologies}
\alias{olsUpdated}
\alias{olsUpdated,character}
\alias{olsUpdated,olsOntology}
\alias{olsUpdated,olsOntologies}
\alias{olsStatus}
\alias{olsStatus,character}
\alias{olsStatus,olsOntology}
\alias{olsStatus,olsOntologies}
\alias{olsPrefix}
\alias{olsPrefix,character}
\alias{olsPrefix,olsOntology}
\alias{olsPrefix,olsOntologies}
\alias{olsDesc}
\alias{olsDesc,character}
\alias{olsDesc,olsOntology}
\alias{olsDesc,olsOntologies}
\alias{olsTitle}
\alias{olsTitle,character}
\alias{olsTitle,olsOntology}
\alias{olsTitle,olsOntologies}
\alias{olsNamespace}
\alias{olsNamespace,character}
\alias{olsNamespace,olsOntology}
\alias{olsNamespace,olsOntologies}
\alias{ontologyUrl}
\alias{ontologyUrl,character}
\alias{ontologyUrl,olsOntology}
\alias{as.data.frame.olsOntologies}
\alias{olsOntologies,missing-method}
\alias{olsOntology,character-method}
\alias{olsOntology,olsOntology-method}
\alias{show,olsOntology-method}
\alias{show,olsOntologies-method}
\alias{olsVersion,character-method}
\alias{olsVersion,olsOntology-method}
\alias{olsVersion,olsOntologies-method}
\alias{olsLoaded,character-method}
\alias{olsLoaded,olsOntology-method}
\alias{olsLoaded,olsOntologies-method}
\alias{olsLinks,olsOntology-method}
\alias{olsConfig,olsOntology-method}
\alias{olsUpdated,character-method}
\alias{olsUpdated,olsOntology-method}
\alias{olsUpdated,olsOntologies-method}
\alias{olsPrefix,character-method}
\alias{olsPrefix,olsOntology-method}
\alias{olsPrefix,olsOntologies-method}
\alias{olsDesc,character-method}
\alias{olsDesc,olsOntology-method}
\alias{olsDesc,olsOntologies-method}
\alias{olsTitle,character-method}
\alias{olsTitle,olsOntology-method}
\alias{olsTitle,olsOntologies-method}
\alias{olsStatus,character-method}
\alias{olsStatus,olsOntology-method}
\alias{olsStatus,olsOntologies-method}
\alias{olsNamespace,character-method}
\alias{olsNamespace,olsOntology-method}
\alias{olsNamespace,olsOntologies-method}
\alias{ontologyUrl,character-method}
\alias{ontologyUrl,olsOntology-method}
\alias{lapply,olsOntologies-method}
\alias{[,olsOntologies-method}
\alias{[[,olsOntologies-method}
\alias{length,olsOntologies-method}
\title{olsOntologies}
\usage{
\S4method{olsOntologies}{missing}(object)

\S4method{olsOntology}{character}(object)

\S4method{olsOntology}{olsOntology}(object)

\S4method{show}{olsOntology}(object)

\S4method{show}{olsOntologies}(object)

\S4method{olsVersion}{character}(object)

\S4method{olsVersion}{olsOntology}(object)

\S4method{olsVersion}{olsOntologies}(object)

\S4method{olsLoaded}{character}(object)

\S4method{olsLoaded}{olsOntology}(object)

\S4method{olsLoaded}{olsOntologies}(object)

\S4method{olsLinks}{olsOntology}(object)

\S4method{olsConfig}{olsOntology}(object)

\S4method{olsUpdated}{character}(object)

\S4method{olsUpdated}{olsOntology}(object)

\S4method{olsUpdated}{olsOntologies}(object)

\S4method{olsPrefix}{character}(object)

\S4method{olsPrefix}{olsOntology}(object)

\S4method{olsPrefix}{olsOntologies}(object)

\S4method{olsDesc}{character}(object)

\S4method{olsDesc}{olsOntology}(object)

\S4method{olsDesc}{olsOntologies}(object)

\S4method{olsTitle}{character}(object)

\S4method{olsTitle}{olsOntology}(object)

\S4method{olsTitle}{olsOntologies}(object)

\S4method{olsStatus}{character}(object)

\S4method{olsStatus}{olsOntology}(object)

\S4method{olsStatus}{olsOntologies}(object)

\S4method{olsNamespace}{character}(object)

\S4method{olsNamespace}{olsOntology}(object)

\S4method{olsNamespace}{olsOntologies}(object)

\S4method{ontologyUrl}{character}(object)

\S4method{ontologyUrl}{olsOntology}(object)

\S4method{lapply}{olsOntologies}(X, FUN, ...)

\S4method{[}{olsOntologies}(x, i, j = "missing", drop = "missing")

\S4method{[[}{olsOntologies}(x, i, j = "missing", drop = "missing")

\S4method{length}{olsOntologies}(x)
}
\arguments{
\item{object}{an instance of class `olsOntologies` or `olsOntology`. For
some functions, a ontology identifier is applicable.}

\item{X}{`olsOntologies` object.}

\item{FUN}{a `function` to be applied to each `olsOntology` element
of `X`.}

\item{...}{additional arguments passed to `FUN`.}

\item{x}{an `olsOntologies` object.}

\item{i}{index of elecements to subset.}

\item{j}{ignored.}

\item{drop}{ignored.}
}
\description{
The rols package provides an interface to PRIDE's Ontology Lookup
Servive (OLS) and can be used to query one or multiple ontologies,
stored as `olsOntology` and `olsOntologies` instances, and
containing various information as provided by OLS.
}
\details{
Ontologies are referred to by their namespace, which is lower
case: the Gene Onology is "go", the Mass spectrometry ontology is
"ms", etc. The ontologies also have prefixes, which are upper
case: the Gene Onology prefix "GO", the Mass spectrometry ontology
prefix "MS". One exception to this rule is the Drosophila
Phenotype Ontology, whose namespace and prefix are "dpo" and
"FBcv" respectively (there might be more). This is particularly
confusing as the FlyBase Controlled Vocabulary has "fbcv" and
"FBcv" as namespace and prefix respectively.

When using a character to initialise an ontology or query a term,
"fbcv" (this is case insensitive) will refer to the the FlyBase
Controlled Vocabulary. The the Drosophila Phenotype Ontology will
have to be referred as "dpo" (also case insensitive).
}
\section{Constructors}{


Objects can be created in multiple ways. The [olsOntologies()]
function will initialise all available ontolgies as an
`olsOntologies` object, while a call to [olsOntology()] with an
ontology namespace or prefix as argument will initialise the
ontology of interest as an `olsOntology` instance.

`Ontolgies` instances can be subset with `[` and `[[` (using their
namespace, see Details) and iterated over with
`lapply`. `Ontolgies` can be converted into a simple `data.frame`
containing the ontology prefixes, namespaces and titles using
`as(., "data.frame")`. `olsOntologies` can also be coerced to
lists of `olsOntology` ojects with `as(., "list")`.
}

\section{Accessors}{


- `olsDesc(object = "olsOntology")` returns the description of an
  ontology. Also works for `olsOntologies` objects and a `character`
  describing an ontology namespace or prefix (see Details).

- `olsPrefix(object = "olsOntology")` retruns the prefix of an
  ontology. Also works for `olsOntologies` objects and a `character`
  describing an ontology namespace or prefix (see Details).

- `olsVersion(object = "olsOntology")` returns the version of the
  ontology. Also works with an a `character` defining an ontology
  namespace or prefix (see Details) or an object of class
  `olsOntologies`, in which case it returns a list of versions.

- `olsLoaded(object = "olsOntology")` returns the loading date of the
  ontology. Also works with a `character` containing the ontology
  namespace or prefix (see Details) or an object of class
  `olsOntologies`.

- `olsUpdated(object = "olsOntology")` returns the update date of the
  ontology. Also works with a `character` containing the ontology
  namespace or prefix (see Details) or an object of class
  `olsOntologies`.

- `olsStatus(object = "olsOntology")` returns the status of the
   ontology. Also works with a `character` containing the ontology
   namespace or prefix (see Details) or an object of class
   `olsOntologies`.

- `olsTitle(object = "olsOntology")` returns the title of an
   ontology. Also works with a `character` containing the ontology
   namespace or prefix (see Details) or an object of class
   `olsOntologies`.

- `olsNamespace(object = "olsOntology")` returns the namespace of an
  ontology. Also works with a `character` containing the ontology
  namespace or prefix (see Details) or an object of class
  `olsOntologies`.

- `olsLinks(object = "olsOntology")` returns a named `character` with
  hyperlink to the ontology itself, and other associated concepts
  such as its terms.

- `olsConfig(object = "olsOntology")` returns a list of additional
   unstructured, partly redundant information about the ontology.

- `ontologyUrl(object = "olsOntology") return the hyperlink to the
  ontology itself. It can also be used with a `character` defining
  the namespace or prefix of an ontology, in which case it is
  created from the base OLS API URL.
}

\section{Ontology terms}{


Once an ontology has been created an an `olsOntology` instance, all
its terms can be requested using the `Terms()` constructor. See
[Terms()] for details.
}

\examples{

#############################
## All ontologies
(onts <- olsOntologies())

#############################
## Alzheimer's Disease Ontology (ADO)
## 1. From the ontologies object
(ado1 <- onts[['ado']])
## 2. Create from its namespace
(ado2 <- olsOntology('ado')) ## also works with ADO

all.equal(ado1, ado2)

olsVersion(ado1)
olsPrefix(ado1)
olsNamespace(ado1)
olsTitle(ado1)
olsDesc(ado1)
olsLinks(ado1)
str(olsConfig(ado1))
}
\references{
- OLS3 API (the OLS4 API should function identically to the OLS3):
  <http://www.ebi.ac.uk/ols4/ols3help>

- REST API for OLS: <https://www.ebi.ac.uk/ols4/swagger-ui/index.html>
}
\author{
Laurent Gatto
}
