% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OlsSearch.R
\docType{class}
\name{OlsSearch}
\alias{OlsSearch}
\alias{.OlsSearch}
\alias{olsSearch}
\alias{olsRows}
\alias{'olsRows<-'}
\alias{allRows}
\alias{as.data.frame.OlsSearch}
\alias{show,OlsSearch-method}
\alias{olsRows<-}
\title{Querying OLS}
\usage{
OlsSearch(
  q,
  ontology = "",
  type = "",
  slim = "",
  fieldList = "",
  queryFields = "",
  exact = FALSE,
  groupField = FALSE,
  obsoletes = FALSE,
  local = TRUE,
  childrenOf = "",
  rows = 20L,
  start = 0L
)

olsSearch(object, all = FALSE)

\S4method{show}{OlsSearch}(object)

olsRows(object)

olsRows(object) <- value

allRows(object)
}
\arguments{
\item{q}{`characher(1)` containing the search query.}

\item{ontology}{`character()` defining the ontology to be
queried. Default is the empty character, to search all
ontologies.}

\item{type}{`character()` restricting the search to an entity
type, one of `"class"`, `"property"`, `"individual"` or
`"ontology"`.}

\item{slim}{`character()` restricts the search to an particular
set of slims by name.}

\item{fieldList}{`character()` specifcies the fields to return.
The defaults are iri, label, short_form, obo_id,
ontology_name, ontology_prefix, description and type. Default
is `""` for all fields.}

\item{queryFields}{`character()` specifcies the fields to query,
the defaults are label, synonym, description, short_form,
obo_id, annotations, logical_description, iri. Default is `""`
for all fields.}

\item{exact}{`logical(1)` defining if exact matches should be
returned. Default is `FALSE`.}

\item{groupField}{`logical(1)`, set to `TRUE` to group results by
unique id (IRI).}

\item{obsoletes}{`logical(1)` defining whether obsolete terms
should be queried. Default is `FALSE`.}

\item{local}{`character(1)`, default is `FALSE`. Set to `TRUE` to
only return terms that are in a defining ontology e.g. only
return matches to gene ontology terms in the gene ontology,
and exclude ontologies where those terms are also referenced.}

\item{childrenOf}{`character()` to restrict a search to children
of a given term. Supply a list of IRI for the terms that you
want to search under.}

\item{rows}{`integer(1)` defining the number of query
returns. Default is 20L. Maximum number of values returned by
the server is 1000. To retrieve the next results, set `start`
1000. See examle below.}

\item{start}{`integer(1)` defining the results page.
number. Default is 0L.}

\item{object}{`OlsSeach` result object.}

\item{all}{`logical(1)` Should all rows be retrieved. Default is
`FALSE`. Can also be set in the queary object directly with
`allRows()`.}

\item{value}{replacement value}
}
\description{
Searching the Ontology Lookup Service is done first by creating an
object `OlsSearch` using the `OlsSearch()` constructor. Query
responses are then retrieved with the `olsSearch()` function.
}
\examples{

## Many results across all ontologies
OlsSearch(q = "trans-golgi")

## Exact matches
OlsSearch(q = "trans-golgi", exact = TRUE)

## Exact match in the gene ontology (go or GO) only
OlsSearch(q = "trans-golgi", exact = TRUE, ontology = "go")
OlsSearch(q = "trans-golgi", exact = TRUE, ontology = "GO")

## Exact match in the GO and Uberon
OlsSearch(q = "trans-golgi", exact = TRUE,
          ontology = c("GO", "Uberon"))

## Testing different ESI queries
OlsSearch(q = "electrospray", ontology = "MS")
OlsSearch(q = "ionization", ontology = "MS")
OlsSearch(q = "electrospray ionization", ontology = "MS")
OlsSearch(q = "electrospray ionization", ontology = "MS", exact=TRUE)

## Request 5 results instead of 20 (default)
OlsSearch(q = "plasma,membrane", ontology = "go", rows = 5)
## Same as above
OlsSearch(q = "plasma membrane", ontology = "go", rows = 5)

## or, once the object was created
(res <- OlsSearch(q = "plasma,membrane", ontology = "go"))
olsRows(res) <- 5
res

## all results
res <- allRows(res)
res

res <- OlsSearch(q = "trans-golgi", ontology = "go", rows = 5)
res
res <- olsSearch(res)
res
as(res, "data.frame")
trms <- as(res, "olsTerms")
trms
termPrefix(trms)
termId(trms)

## Setting rows and start parameters
tg1 <- OlsSearch(q = "trans-golgi", rows = 5, start = 0) |>
                 olsSearch() |>
                 as("data.frame")
tg2 <- OlsSearch(q = "trans-golgi", rows = 5, start = 5) |>
                 olsSearch() |>
                 as("data.frame")
tg3 <- OlsSearch(q = "trans-golgi", rows = 10, start = 0) |>
                 olsSearch() |>
                 as("data.frame")

## The two consecutive small results are identical
## to the larger on.
identical(rbind(tg1, tg2), tg3)
}
\references{
- OLS3 API (the OLS4 API should function identically to the OLS3):
  <http://www.ebi.ac.uk/ols4/ols3help>

- REST API for OLS: <https://www.ebi.ac.uk/ols4/swagger-ui/index.html>
}
\author{
Laurent Gatto
}
