% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSD.R
\name{plotSD}
\alias{plotSD}
\title{Estimate And Plot Median Standard Deviation}
\usage{
plotSD(dat, constant = 0.5, loessspan = 1/3, thresholds = c(1, 6),
  plotcell = 1, ...)
}
\arguments{
\item{dat}{A \code{rnaseqcomp} S4 class object.}

\item{constant}{A numeric pseudo-constant to be added on all
the signals before transferred to log scale. (default: 0.5)}

\item{loessspan}{A numeric number indicating span used
for loess smooth. Details see
\code{loess.smooth} function. (Default: 1/3)}

\item{thresholds}{A vector of two numbers define cutoffs for
three levels of detreded log signals. (default: c(1, 6))}

\item{plotcell}{1 or 2 indicating which cell line
will be plotted. If values other than 1 and 2, both cell
lines will be plotted.  This value won't affect estimation for both
cell lines. (default: 1)}

\item{...}{Parameters for base function \code{plot}.}
}
\value{
\item{plot}{SD plots of quantification pipelines for
selected cell line by \code{plotcell}.}
\item{list}{A list of two matrices of median and standard error of
standard deviations.}
}
\description{
For each cell line in each pipeline,
the standard deviation of detrend logsignals are calculated
for individual features. Then, loess smooth on standard
deviation are plotted stratified by detrended log signals
for select cell line. The median of standard deviation at
three different levels of detrend logsignals are reported.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
plotSD(dat)
}
