% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_PlotEditingCorrelations.R
\name{PlotEditingCorrelations}
\alias{PlotEditingCorrelations}
\title{Plotting correlations of RNA editing levels within a region.}
\usage{
PlotEditingCorrelations(region_gr, rnaEditMatrix, ...)
}
\arguments{
\item{region_gr}{A GRanges object of a region.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values on
individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{...}{Dots for additional internal arguments, see 
\code{\link[corrplot]{corrplot}} for details.}
}
\value{
(Invisibly) returns a reordered correlation matrix.
}
\description{
Plotting correlations of RNA editing levels within a region.
}
\examples{
  data(rnaedit_df)
  
  genes_gr <- TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  exm_regions <- AllCoeditedRegions(
    regions_gr = genes_gr,
    rnaEditMatrix = rnaedit_df,
    output = "GRanges",
    method = "spearman"
  )
  
  PlotEditingCorrelations(
    region_gr = exm_regions[1],
    rnaEditMatrix = rnaedit_df
  )
   
}
\keyword{internal}
