% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_CreateOutputDF.R
\name{CreateOutputDF}
\alias{CreateOutputDF}
\title{Create output data in the format of data frame.}
\usage{
CreateOutputDF(
  keepSites_df,
  keepContiguousSites_df,
  keepminPairwiseCor_df,
  returnAllSites = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{keepSites_df}{An output data frame from function 
\code{MarkCoeditedSites}, with variables \code{site, keep, ind, r_drop}. 
Please see \code{\link{MarkCoeditedSites}} for details.}

\item{keepContiguousSites_df}{An output data frame from function
\code{FindCorrelatedRegions} with variables \code{site, subregion}. Please
see \code{\link{FindCorrelatedRegions}} for details.}

\item{keepminPairwiseCor_df}{An output data frame from function
\code{GetMinPairwiseCor} with variables \code{subregion},
\code{keepminPairwiseCor} and \code{minPairwiseCor}. Please see
\code{\link{GetMinPairwiseCor}} for details.}

\item{returnAllSites}{When no contiguous co-edited regions are found in
a input genomic region, \code{returnAllSites = TRUE} indicates
outputting all the sites in this input region, while
\code{returnAllSites = FALSE} indicates not returning any site in this
input region. Defaults to FALSE.}

\item{verbose}{Should messages and warnings be displayed? Defaults to TRUE.}
}
\value{
A data frame with following columns:
  \itemize{
    \item{\code{site} : }{site ID.}
    \item{\code{chr} : }{chromosome number.}
    \item{\code{pos} : }{genomic location.}
    \item{\code{r_drop} : }{the correlation between RNA editing levels of 
    one site and the mean RNA editing levels of the rest of the sites.}
    \item{\code{keep} : }{indicator for co-edited sites, The sites with
    \code{keep = 1} belong to the contiguous and co-edited region.}
    \item{\code{keep_contiguous} : }{contiguous co-edited region number.}
    \item{\code{regionMinPairwiseCor} : }{the minimum pairwise correlation 
    between sites within a sub-region.}
    \item{\code{keep_regionMinPairwiseCor} : }{indicator for contiguous
    co-edited subregions, The regions with \code{keepminPairwiseCor = 1}
    are the ones that passed \code{regionMinPairwiseCor} filter and will be 
    returned as a contiguous co-edited sub-region.}
  }
}
\description{
Output all the contiguous co-edited subregions found by
  \code{\link{FindCorrelatedRegions}} function and filtered by
  \code{\link{GetMinPairwiseCor}} function.
}
\examples{
  data(t_rnaedit_df)
  
  ordered_cols <- OrderSitesByLocation(
    sites_char = colnames(t_rnaedit_df),
    output = "vector"
  )
  exm_data <- t_rnaedit_df[, ordered_cols]
  
  exm_sites <- MarkCoeditedSites(
    rnaEditCluster_mat = exm_data,
    method = "spearman"
  )
  
  exm_regions <- FindCorrelatedRegions(
    sites_df = exm_sites,
    featureType = "site"
  )
  
  exm_probes <- split(
    x = exm_regions$site,
    f = exm_regions$subregion
  )
  
  exm_cor <- GetMinPairwiseCor(
    rnaEditCluster_mat = exm_data,
    minPairCorr = 0.1,
    probes_ls = exm_probes,
    method = "spearman"
  )
  
  CreateOutputDF(
    keepSites_df = exm_sites,
    keepContiguousSites_df = exm_regions,
    keepminPairwiseCor_df = exm_cor$keepminPairwiseCor_df
  )
   
}
\keyword{internal}
