% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_visualization.r
\name{rifi_visualization}
\alias{rifi_visualization}
\title{\subsection{=========================================================================
rifi_visualization}{

rifi_visualization plots all the data with fragments and events from both
strands
}}
\usage{
rifi_visualization(
  data,
  genomeLength,
  annot,
  coverage = 0,
  chr_fwd = NA,
  chr_rev = NA,
  region = c("CDS", "asRNA", "5'UTR", "ncRNA", "3'UTR", "tRNA"),
  color_region = c("grey0", "red", "blue", "orange", "yellow", "green", "white",
    "darkseagreen1", "grey50", "black"),
  color_text.1 = "grey0",
  color_text.2 = "black",
  color_TU = "blue",
  Alpha = 0.5,
  size_tu = 1.6,
  size_locusTag = 1.6,
  size_gene = 1.6,
  Limit = 10,
  shape = 22,
  col_outiler = "grey50",
  col_coverage = "grey",
  shape_outlier = 13,
  limit_intensity = NA,
  face = "bold",
  tick_length = 0.3,
  arrow.color = "darkseagreen1",
  minVelocity = 3000,
  medianVelocity = 6000,
  col_above20 = "#00FFFF",
  fontface = "plain",
  shape_above20 = 14,
  col_outlierabove10 = "darkorchid",
  shape_outlierabove10 = 5,
  axis_text_y_size = 3,
  axis_title_y_size = 6,
  TI_threshold = 1.1,
  termination_threshold = -0.5,
  iTSS_threshold = 0.5,
  p_value_int = 0.05,
  p_value_event = 0.05,
  p_value_hl = 0.05,
  p_value_TI = 0.05,
  p_value_manova = 0.05,
  event_duration_ps = 1,
  event_duration_itss = -1,
  HL_threshold_1 = log2(1.5),
  HL_threshold_2 = -log2(1.5),
  vel_threshold = 200,
  HL_threshold_color = "black",
  vel_threshold_color = "grey52",
  ps_color = "orange",
  iTSS_I_color = "blue"
)
}
\arguments{
\item{data}{SummarizedExperiment: the input data frame with correct format.}

\item{genomeLength}{integer: genome length output of gff3_preprocess
function and element of metadata of SummarizedExperiment.}

\item{annot}{dataframe: the annotation file, output of gff3_preprocess
function and element of metadata of SummarizedExperiment.}

\item{coverage}{integer: in case the coverage is available.}

\item{chr_fwd}{string object: coverage of the forward strand.}

\item{chr_rev}{string object: coverage of the reverse strand.}

\item{region}{dataframe: gff3 features of the genome.}

\item{color_region}{string vector: vector of colors.}

\item{color_text.1}{string: TU color text}

\item{color_text.2}{string: genes color text}

\item{color_TU}{string. TU color}

\item{Alpha}{integer: color transparency degree.}

\item{size_tu}{integer: TU size}

\item{size_locusTag}{integer: locus_tag size}

\item{size_gene}{integer: font size for gene annotation.}

\item{Limit}{integer: value for y-axis limit.}

\item{shape}{integer: value for shape.}

\item{col_outiler}{string: outlier color.}

\item{col_coverage}{integer: color for coverage plot.}

\item{shape_outlier}{integer: value for outlier shape.}

\item{limit_intensity}{integer: intensity limit if applicable.}

\item{face}{string: label font.}

\item{tick_length}{integer: value for ticks.}

\item{arrow.color}{string: arrows color.}

\item{minVelocity}{integer: threshold to fix the minimum of velocity.}

\item{medianVelocity}{integer: threshold to fix the maximum of velocity.}

\item{col_above20}{string: color for probes/bin above value 20.}

\item{fontface}{integer: font type}

\item{shape_above20}{integer: shape for probes/bins above value 20.}

\item{col_outlierabove10}{string: color for probes/bin outliers between 10
and 20,}

\item{shape_outlierabove10}{integer: shape for probes/bin outliers between 10
and 20,}

\item{axis_text_y_size}{integer: text size for y-axis.}

\item{axis_title_y_size}{integer: title size for y-axis.}

\item{TI_threshold}{integer: threshold for TI between two fragments in case
the TI termination factor drops from the first segment to the second,
default 1.1. If threshold is reached a line is drawn to seperates the two TI segments.}

\item{termination_threshold}{integer: threshold for termination to plot,
default .8.}

\item{iTSS_threshold}{integer: threshold for iTSS_II selected to plot,
default 1.2.}

\item{p_value_int}{integer: p_value of intensity fragments fold-change to
plot, default 0.05.}

\item{p_value_event}{integer: p_value of t-test from pausing site and
iTSS_I events to plot, default 0.05.}

\item{p_value_hl}{integer: p_value of half_life fragments fold-change to
plot, default 0.05.}

\item{p_value_TI}{integer: p_value of TI fragments selected to be plotted,
default 0.05.}

\item{p_value_manova}{integer: p_value of manova test fragments to plot,
default 0.05.}

\item{event_duration_ps}{integer: threshold for pausing sites selected to
plot, default -2.}

\item{event_duration_itss}{integer: threshold for iTSS_I selected to
plot, default 2.}

\item{HL_threshold_1}{integer: threshold for log2FC(HL) selected to plot,
default log2(1.5). log2FC(HL) >= log2(1.5) are indicated by black color.
If p_value <= p_value_hl (default 0.05), log2FC(HL) is indicated by HL*
otherwise HL.}

\item{HL_threshold_2}{integer: threshold for log2FC(HL) selected to plot,
default -log2(1.5). log2FC(HL) <= -log2(1.5) are indicated by green color.
If p_value <= p_value_hl (default 0.05), log2FC(HL) is indicated by HL*
otherwise HL.
In case of p_value is significant and the log2FC(HL) is between -log2FC(1.5)
and log2FC(1.5), FC is assigned by green color and HL*.}

\item{vel_threshold}{integer: threshold for velocity ratio selected to plot,
default 200.}

\item{HL_threshold_color}{string: color for HL fold change plot.}

\item{vel_threshold_color}{string: color for velocity ratio plot.}

\item{ps_color}{string: color for pausing site plot.}

\item{iTSS_I_color}{string: color for iTSS_I plot.}
}
\value{
The visualization plot.
}
\description{
rifi_visualization plots the whole genome with genes, transcription units
(TUs), delay, half-life (HL), intensity fragments, features, events,
velocity, annotation, coverage if available.
}
\details{
rifi_visualization uses several functions to plot the genes including
as-RNA and ncRNA and TUs as segments.
The function plots delay, HL and intensity fragments with statistical t-test
between the neighboring fragment, significant t-test is assigned with '\emph{'.
t-test and Manova statistical test are also depicted as '}'.

The functions used are:
\enumerate{
\item annotation_plot: plots the corresponding annotation.
\item positive_strand_function: plots delay, HL, intensity and events of
positive strand.
\item negative_strand_function: plots delay, HL, intensity and events of negative
strand.
\item empty_data_positive: plots empty boxes in case no data is available for
positive strand.
\item empty_data_negative: plots empty boxes in case no data is available for
negative strand.
\item strand_selection: check if data is stranded and arrange by position.
\item splitGenome_function: splits the genome into fragments.
\item indice_function: assign a new column to the data to distinguish between
fragments, outliers from delay or HL or intensity.
\item TU_annotation: designs the segments border for the genes and TUs annotation
\item gene_annot_function: it requires gff3 file, returns a dataframe adjusting
each fragment according to its annotation. It allows as well the plot of
genes and TUs shared into two pages.
\item label_log2_function: used to add log scale to intensity values.
\item label_square_function: used to add square scale to coverage values.
\item coverage_function: this function is used only in case of coverage is
available.
\item secondaryAxis: adjusts the half-life or delay to 20 in case of the
dataframe row numbers is equal to 1 and the half-life or delay exceed
the limit, they are plotted with different shape and color.
\item outlier_plot: plot the outliers with half-life between 10 and 30 on the
maximum of the yaxis.
\item add_genomeBorders: when the annotated genes are on the borders, they can
not be plotted, therefore the region was split in 2 adding the row
corresponding to the split part to the next annotation (i + 1) except
for the first page.
\item my_arrow: creates an arrow for the annotation.
\item arrange_byGroup: selects the last row for each segment and add 40
nucleotides in case of negative strand for a nice plot.
\item regr: plots the predicted delay from linear regression if the data is on
negative strand.
\item meanPosition: assign a mean position for the plot.
\item delay_mean: adds a column in case of velocity is NA or equal to 60.
The mean of the delay is calculated outliers.
\item my_segment_T: plots terminals and pausing sites labels.
\item my_segment_NS: plots internal starting sites 'iTSS'.
\item min_value: returns minimum value for event plots in intensity plot.
\item velocity_fun: function for velocity plot.
\item limit_function: for values above 10 or 20 in delay and hl. Limit of the
axis is set differently. y-axis limit is applied only if we have more than 3
values above 10 and lower or equal to 20. An exception is added in case a
dataframe has less than 3 rows and 1 or more values are above 10, the rest of
the values above 20 are adjusted to 20 on "secondaryAxis" function.
\item empty_boxes: used only in case the dataframe from the positive strand is
not empty, the TU are annotated.
\item function_TU_arrow: used to avoid plotting arrows when a TU is split into
two pages.
\item terminal_plot_lm: draws a linear regression line when terminal outliers
have an intensity above a certain threshold and are consecutive. Usually are
smallRNA (ncRNA, asRNA).
\item slope_function: replaces slope lower than 0.0009 to 0.
\item velo_function: replaces infinite velocity with NA.
\item plot the coverage of RNA_seq in exponential phase growth
}
}
\examples{
data(stats_minimal)
if(!require(SummarizedExperiment)){
suppressPackageStartupMessages(library(SummarizedExperiment))
}
rifi_visualization(data = stats_minimal, 
genomeLength = metadata(stats_minimal)$annot[[2]],
annot = metadata(stats_minimal)$annot[[1]])

}
