% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_fit.r
\name{rifi_fit}
\alias{rifi_fit}
\title{\subsection{=========================================================================
rifi_fit}{

rifi_fit wraps conveniently all fitting steps
}}
\usage{
rifi_fit(
  inp,
  cores = 1,
  viz = FALSE,
  restr = 0.2,
  decay = seq(0.08, 0.11, by = 0.02),
  delay = seq(0, 10, by = 0.1),
  k = seq(0.1, 1, 0.2),
  bg = 0.2,
  TI_k = seq(0, 1, by = 0.5),
  TI_decay = c(0.05, 0.1, 0.2, 0.5, 0.6),
  TI = seq(0, 1, by = 0.5),
  TI_delay = seq(0, 2, by = 0.5),
  TI_rest_delay = seq(0, 2, by = 0.5),
  TI_bg = 0
)
}
\arguments{
\item{inp}{SummarizedExperiment: the input with correct format.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{viz}{logical: whether to visualize the output.}

\item{restr}{numeric: a parameter that restricts the freedom of the fit to
avoid wrong TI-term_factors, ranges from 0 to 0.2}

\item{decay}{numeric vector: A sequence of starting values for the decay.
Default is seq(.08, 0.11, by=.02)}

\item{delay}{numeric vector: A sequence of starting values for the delay.
Default is seq(0,10, by=.1)}

\item{k}{numeric vector: A sequence of starting values for the synthesis
rate.Default is seq(0.1,1,0.2)}

\item{bg}{numeric vector: A sequence of starting values. Default is 0.2.}

\item{TI_k}{numeric vector: A sequence of starting values for the synthesis
rate. Default is seq(0, 1, by = 0.5).}

\item{TI_decay}{numeric vector: A sequence of starting values for the decay.
Default is c(0.05, 0.1, 0.2, 0.5, 0.6).}

\item{TI}{numeric vector: A sequence of starting values for the TI. Default
is  seq(0, 1, by = 0.5).}

\item{TI_delay}{numeric vector: A sequence of starting values for the delay.
Default is seq(0, 2, by = 0.5).}

\item{TI_rest_delay}{numeric vector: A sequence of starting values. Default
is seq(0, 2, by = 0.5).}

\item{TI_bg}{numeric vector: A sequence of starting values. Default is 0.}
}
\value{
the SummarizedExperiment object: with delay, decay  and
TI_termination_factor added to the rowRanges. The full fit data is saved in
the metadata as "fit_STD" and "fit_TI". A plot is given if viz = TRUE.
}
\description{
rifi_fit wraps the functions:
\enumerate{
\item nls2_fit
\item TI_fit
\item plot_nls2_function
\item plot_singleProbe_function
}
}
\examples{
data(preprocess_minimal)
rifi_fit(
  inp = preprocess_minimal,
  cores = 1, viz = FALSE, restr = 0.1,
  decay = seq(.08, 0.11, by = .02),
  delay = seq(0, 10, by = .1), k = seq(0.1, 1, 0.2), bg = 0.2,
  TI_k = seq(0, 1, by = 0.5), TI_decay = c(0.05, 0.1, 0.2, 0.5, 0.6),
  TI = seq(0, 1, by = 0.5), TI_delay = seq(0, 2, by = 0.5),
  TI_rest_delay = seq(0, 2, by = 0.5), TI_bg = 0
)

}
\seealso{
\code{nls2_fit}

\code{TI_fit}

\code{plot_nls2}

\code{plot_singleProbe}
}
