% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragment_HL.r
\name{fragment_HL}
\alias{fragment_HL}
\title{\subsection{=========================================================================
fragment_HL}{

fragment_HL performs the half_life fragmentation
}}
\usage{
fragment_HL(inp, cores = 1, pen, pen_out)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{pen}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default is the auto generated value.}

\item{pen_out}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer allowed outliers. Default is the auto
generated value.}
}
\value{
The SummarizedExperiment object:
\describe{
\item{ID:}{The bin/probe specific ID}
\item{position:}{The bin/probe specific position}
\item{intensity:}{The relative intensity at time point 0}
\item{probe_TI:}{An internal value to determine which fitting model is
applied}
\item{flag:}{Information on which fitting model is applied}
\item{position_segment:}{The position based segment}
\item{delay:}{The delay value of the bin/probe}
\item{half_life:}{The half-life of the bin/probe}
\item{TI_termination_factor:}{String, the factor of TI fragment}
\item{delay_fragment:}{The delay fragment the bin belongs to}
\item{velocity_fragment:}{The velocity value of the respective delay
fragment}
\item{intercept:}{The vintercept of fit through the respective delay
fragment}
\item{slope:}{The slope of the fit through the respective delay fragment}
\item{HL_fragment:}{The half-life fragment the bin belongs to}
\item{HL_mean_fragment:}{The mean half-life value of the respective
half-life fragment}
}
}
\description{
fragment_HL makes HL_fragments based on delay_fragments and assigns all
gathered information to the SummarizedExperiment object.
}
\details{
The columns "HL_fragment" and "HL_mean_fragment" are added.

fragment_HL makes half-life_fragments and assigns the mean of each fragment.

The function used is:

.score_fun_ave.

The input the SummarizedExperiment object.

pen is the penalty for new fragments in the dynamic programming, pen_out is
the outlier penalty.
}
\examples{
data(fragmentation_minimal)
fragment_HL(inp = fragmentation_minimal, cores = 2, pen = 2, pen_out = 1)

}
