% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_manova.r
\name{apply_manova}
\alias{apply_manova}
\title{\subsection{=========================================================================
apply_manova}{

apply_manova checks if the ratio of hl ratio and intensity ratio is
statistically significant.
}}
\usage{
apply_manova(inp)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}
}
\value{
The probe data frame with the columns regarding statistics:
\describe{
\item{ID:}{The bin/probe specific ID.}
\item{position:}{The bin/probe specific position.}
\item{strand:}{The bin/probe specific strand.}
\item{intensity:}{The relative intensity at time point 0.}
\item{probe_TI:}{An internal value to determine which fitting model
is applied.}
\item{flag:}{Information on which fitting model is applied.}
\item{position_segment:}{The position based segment.}
\item{delay:}{The delay value of the bin/probe.}
\item{half_life:}{The half-life of the bin/probe.}
\item{TI_termination_factor:}{String, the factor of TI fragment.}
\item{delay_fragment:}{The delay fragment the bin belongs to.}
\item{velocity_fragment:}{The velocity value of the respective delay
fragment.}
\item{intercept:}{The vintercept of fit through the respective delay
fragment.}
\item{slope:}{The slope of the fit through the respective delay fragment.}
\item{HL_fragment:}{The half-life fragment the bin belongs to.}
\item{HL_mean_fragment:}{The mean half-life value of the respective
half-life fragment.}
\item{intensity_fragment:}{The intensity fragment the bin belongs to.}
\item{intensity_mean_fragment:}{The mean intensity value of the respective
intensity fragment.}
\item{TU:}{The overarching transcription unit.}
\item{TI_termination_fragment:}{The TI fragment the bin belongs to.}
\item{TI_mean_termination_factor:}{The mean termination factor of the
respective TI fragment.}
\item{seg_ID:}{The combined ID of the fragment.}
\item{pausing_site:}{presence of pausing site indicated by +/-.}
\item{iTSS_I:}{presence of iTSS_I indicated by +/-.}
\item{ps_ts_fragment:}{The fragments involved in pausing site or iTSS_I.}
\item{event_duration:}{Integer, the duration between two delay fragments.}
\item{event_ps_itss_p_value_Ttest:}{p_value of pausing site or iTSS_I.}
\item{p_value_slope:}{Integer, the p_value added to the inp.}
\item{delay_frg_slope:}{Integer, the slope value of the fit through the
respective delay fragment.}
\item{velocity_ratio:}{Integer, the ratio value of velocity from 2 delay
fragments.}
\item{event_position:}{Integer, position of the event added to the input.}
\item{FC_HL:}{Integer, the fold change value of 2 HL fragments.}
\item{FC_fragment_HL:}{String, the fragments corresponding to HL fold
change.}
\item{p_value_HL:}{Integer, the p_value added to the input of 2 HL
fragments.}
\item{FC_intensity:}{Integer, the fold change value of 2 intensity
fragments.}
\item{FC_fragment_intensity:}{String, the fragments corresponding to
intensity fold change.}
\item{p_value_intensity:}{Integer, the p_value added to the input of 2
intensity fragments.}
\item{synthesis_ratio:}{Integer, the value correspomding to synthesis rate.}
\item{synthesis_ratio_event:}{String, the event assigned by synthesis
rate either Termination or iTSS.}
\item{FC_HL_intensity:}{Integer, the value corresponding to HL and
intensity fold change.}
\item{FC_HL_intensity_fragment:}{String, the fragments corresponding to
intensity and HL fold change.}
\item{FC_HL_adapted:}{Integer, the fold change of half-life/ fold change
of intensity,position of the half-life fragment is adapted to intensity
fragment.}
\item{p_value_Manova:}{Integer, the p_value added to the input.}
}
}
\description{
apply_manova compares the variance between two fold-changes HL and intensity
within the same TU (half-life frgA/half-life frgB/intensity
frgA/intensity frgB). HL fragment could cover two intensity fragments
therefore this function sets first fragments borders and uses manova_function.
Manova checks the variance between 2 segments (independent variables) and two
dependents variables (HL and intensity).
}
\examples{
data(stats_minimal)
apply_manova(inp = stats_minimal)

}
