% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TUgether.r
\name{TUgether}
\alias{TUgether}
\title{\subsection{=========================================================================
TUgether}{

TUgether combines delay fragments into TUs
}}
\usage{
TUgether(inp, cores = 1, pen = -0.75)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{cores}{cores: integer: the number of assigned cores for the task.}

\item{pen}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Default -0.75.}
}
\value{
The SummarizedExperiment with the columns regarding the TU:
\describe{
\item{ID:}{The bin/probe specific ID.}
\item{position:}{The bin/probe specific position.}
\item{intensity:}{The relative intensity at time point 0.}
\item{probe_TI:}{An internal value to determine which fitting model is
applied.}
\item{flag:}{Information on which fitting model is applied.}
\item{position_segment:}{The position based segment.}
\item{delay:}{The delay value of the bin/probe.}
\item{half_life:}{The half-life of the bin/probe.}
\item{TI_termination_factor:}{String, the factor of TI fragment.}
\item{delay_fragment:}{The delay fragment the bin belongs to.}
\item{velocity_fragment:}{The velocity value of the respective delay
fragment.}
\item{intercept:}{The vintercept of fit through the respective delay
fragment.}
\item{slope:}{The slope of the fit through the respective delay fragment.}
\item{HL_fragment:}{The half-life fragment the bin belongs to.}
\item{HL_mean_fragment:}{The mean half-life value of the respective
half-life fragment.}
\item{intensity_fragment:}{The intensity fragment the bin belongs to.}
\item{intensity_mean_fragment:}{The mean intensity value of the respective
intensity fragment.}
\item{TU:}{The overarching transcription unit.}
\item{TI_termination_fragment:}{The TI fragment the bin belongs to.}
\item{TI_mean_termination_factor:}{The mean termination factor of the
respective TI fragment.}
\item{seg_ID:}{The combined ID of the fragment.}
}
}
\description{
TUgether combines delay fragments into TUs. The column "TU" is added. It uses
score fun_increasing on the start and end points of delay_fragments.
}
\details{
The function used is:
.score_fun_increasing

The input is the SummarizedExperiment object.
pen is the penalty for new fragments in the dynamic programming. Since high
scores are aimed, pen is negative.
}
\examples{
data(fragmentation_minimal)
TUgether(inp = fragmentation_minimal, cores = 2, pen = -0.75)

}
