% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpliceEvent.R
\name{plotSpliceEvent}
\alias{plotSpliceEvent}
\title{Plot splice event}
\usage{
plotSpliceEvent(
  se,
  tx_name,
  coverage,
  group1,
  group2,
  cutoffFDR = 0.05,
  resetIntronWidth = TRUE
)
}
\arguments{
\item{se}{Output of \link{spliceEvent}}

\item{tx_name}{Transcript name.}

\item{coverage}{Coverages of feature region with extensions.
Output of \link{coverageDepth}}

\item{group1, group2}{The sample names of group 1 and group 2}

\item{cutoffFDR}{Cutoff of FDR}

\item{resetIntronWidth}{logical(1). If set to true,
reset the region with no read to minimal width.}
}
\value{
A ggplot object.
}
\description{
Plot the splice event
}
\examples{
\dontrun{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
coverage <- coverageDepth(RPFs, gtf=gtf, level="gene",
                          region="feature with extension")
group1 <- c("RPF.KD1.1", "RPF.KD1.2")
group2 <- c("RPF.WT.1", "RPF.WT.2")
se <- spliceEvent(coverage, group1, group2)
plotSpliceEvent(se, se$feature[1], coverage, group1, group2)
}
}
