% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFPKM.R
\name{getFPKM}
\alias{getFPKM}
\title{Get FPKM values for counts}
\usage{
getFPKM(counts, gtf, level = c("gene", "tx"))
}
\arguments{
\item{counts}{Output of \link{countReads} or \link{normByRUVs}}

\item{gtf}{GTF file name for annotation.}

\item{level}{Transcript or gene level.}
}
\value{
A list with FPKMs
}
\description{
Calculate Fragments Per Kilobase of transcript per
Million mapped reads (FPKM) for counts.
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
#RPFs <- dir(path, "RPF.*?.[12].bam$", full.names=TRUE)
#RNAs <- dir(path, "mRNA.*?.[12].bam$", full.names=TRUE)
#gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
#cnts <- countReads(RPFs, RNAs, gtf, level="gene")
cnts <- readRDS(file.path(path, "cnts.rds"))
fpkm <- getFPKM(cnts)
}
