% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frameCounts.R
\name{frameCounts}
\alias{frameCounts}
\title{Extract counts for gene level or transcript level}
\usage{
frameCounts(
  reads,
  level = c("tx", "gene"),
  frame0only = TRUE,
  coverageRate = FALSE
)
}
\arguments{
\item{reads}{Output of \link{assignReadingFrame}.}

\item{level}{Transcript or gene level}

\item{frame0only}{Only count for reading frame 0 or not}

\item{coverageRate}{Calculate for coverage or not}
}
\value{
A numeric vector with reads counts.
}
\description{
Calculate the reads counts or coverage rate for gene level or
transcript level.
Coverage is determined by measuring the proportion of in-frame CDS
 positions with >= 1 reads.
}
\examples{
pcs <- readRDS(system.file("extdata", "samplePc.rds",
               package="ribosomeProfilingQC"))
cnts <- frameCounts(pcs)
cnts.gene <- frameCounts(pcs, level="gene")
cvg <- frameCounts(pcs, coverageRate=TRUE)
}
