% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonUsage.R
\name{codonUsage}
\alias{codonUsage}
\title{Start or Stop codon usage}
\usage{
codonUsage(reads, start = TRUE, genome)
}
\arguments{
\item{reads}{Output of \link{assignReadingFrame}.}

\item{start}{Calculate for start codon or stop codon.}

\item{genome}{A BSgenome object.}
}
\value{
Table of codon usage.
}
\description{
Calculate the start or stop codon usage for the identified CDSs.
}
\examples{
pcs <- readRDS(system.file("extdata", "samplePc.rds",
               package="ribosomeProfilingQC"))
library(BSgenome.Drerio.UCSC.danRer10)
codonUsage(pcs, genome=Drerio)
codonUsage(pcs, start=FALSE, genome=Drerio)
}
