% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagene_functions.R
\name{get_tidy_metagene}
\alias{get_tidy_metagene}
\title{Retrieves the metagene data in a tidy format}
\usage{
get_tidy_metagene(
  ribo.object,
  site,
  range.lower = length_min(ribo.object),
  range.upper = length_max(ribo.object),
  length = TRUE,
  compact = TRUE,
  experiment = experiments(ribo.object)
)
}
\arguments{
\item{ribo.object}{A 'Ribo' object}

\item{site}{"start" or "stop" site coverage}

\item{range.lower}{Lower bound of the read length, inclusive}

\item{range.upper}{Upper bound of the read length, inclusive}

\item{length}{Logical value that denotes if the metagene information should be summed across read lengths}

\item{compact}{Option to return a DataFrame with Rle and factor as opposed to a raw data.frame}

\item{experiment}{List of experiment names}
}
\value{
An annotated, tidy DataFrame or data.frame (if the compact parameter is set to FALSE) of the
metagene information for either the 'stop' or 'start' site provided in the 'site' parameter. The data frame,
as a result of its tidy property, will have a position column.
The returned data frame will have a length column when the 'length' parameter is set to FALSE, indicating
will be automatically aggregated to keep the memory footprint of this function reasonable.
}
\description{
The function \code{\link{get_tidy_metagene}} provides the user with a tidy data format for easier
data cleaning and manipulation. In providing this functionality while reducing the returned data frame
size, the user must aggregate across the transcripts and is only provided the option to aggregate the 
read lengths together.
}
\details{
The dimensions of the returned data frame depend on the parameters
range.lower, range.upper, and length.

The param 'length' condenses the read lengths together.
When length is TRUE, then the resulting data frame prints out one row
for each experiment. This provides a tidy format of the metagene information
across all transcripts and all read lengths in a given experiment. Each row
in the data frame represents the total metagene coverage count of a given experiment
at a given position.

When the param  'length' is FALSE, then the resulting data frame prints out the
metagene coverage count at each position of the metagene radius for each read length.
This provides a tidy format of the metagene information across the transcripts, preserving
the metagene coverage count at each read length.
}
\examples{
#generate the ribo object by loading in a ribo function and calling the \code{\link{Ribo}} function
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#extract the total metagene information in a tidy format
#for all experiments across the read lengths and transcripts
#of the start site from read length 2 to 5

metagene_info <- get_tidy_metagene(ribo.object = sample,
                                   site = "start",
                                   range.lower = 2,
                                   range.upper = 5,
                                   length = TRUE,
                                   experiment = experiments(sample))

#Note that length and experiments in this case are the
#default values and can be left out. The following generates the same output.
metagene_info <- get_tidy_metagene(ribo.object = sample,
                                   site = "start",
                                   range.lower = 2,
                                   range.upper = 5)

}
\seealso{
\code{\link{Ribo}} to generate the necessary 'Ribo' class object.
\code{\link{plot_metagene}} to visualize the metagene data,
\code{\link{get_metagene}} to obtain tidy metagene data under certain conditions
}
