% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_count_functions.R
\name{get_length_distribution}
\alias{get_length_distribution}
\title{Retrieves the length distribution of a given region}
\usage{
get_length_distribution(
  ribo.object,
  region,
  range.lower = length_min(ribo.object),
  range.upper = length_max(ribo.object),
  compact = TRUE,
  experiment = experiments(ribo.object)
)
}
\arguments{
\item{ribo.object}{A 'Ribo' object}

\item{region}{Specific region of interest}

\item{range.lower}{Lower bound of the read length, inclusive}

\item{range.upper}{Upper bound of the read length, inclusive}

\item{compact}{Option to return a DataFrame with Rle and factor as opposed to a raw data.frame}

\item{experiment}{List of experiment names}
}
\value{
An annotated DataFrame or data.frame (if the compact parameter is set to FALSE) of the
read-length specific region count information for a single region specified in the 'region' parameter.
The returned data frame will have a length column, and it will not contain a transcript column.
}
\description{
The function {\code{\link{get_length_distribution}}} retrieves the raw or normalized
counts at each read length from 'range.lower' to 'range.upper'.
}
\details{
This function is a wrapper function of {\code{\link{get_region_counts}}}, and the
returned DataFrame is valid input for {\code{\link{plot_length_distribution}}}.
}
\examples{
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#specify the experiments of interest
experiments <- c("Hela_1", "Hela_2", "WT_1")

#gets the normalized length distribution from read length 2 to 5
length.dist <- get_length_distribution(ribo.object = sample,
                                       region = "CDS",
                                       range.lower = 2,
                                       range.upper = 5)

}
\seealso{
{\code{\link{plot_length_distribution}}} to plot the output of this function
}
