% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_functions.R
\name{get_experiments}
\alias{get_experiments}
\title{Provides a list of experiments from a .ribo file}
\usage{
get_experiments(ribo.object)
}
\arguments{
\item{ribo.object}{S4 object of class "Ribo"}
}
\value{
A list of the experiment names
}
\description{
The function \code{\link{get_experiments}} provides a list of experiment names in the .ribo file.
}
\details{
\code{\link{get_experiments}} returns a list of strings denoting the experiments. It obtains this
by reading directly from the .ribo file through the path of the 'ribo.object' parameter. To generate
the param 'ribo.object', call the \code{\link{Ribo}} function and provide the path to the .ribo file of interest.

The user can then choose to create a subset from this list for any specific experiments of interest
for later function calls. Many functions that have the param 'experiment.list'
 call \code{\link{get_experiments}} to generate a default list of all experiments in the
.ribo file.
}
\examples{
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#get a list of the experiments
get_experiments(sample)

}
\seealso{
\code{\link{Ribo}} to generate the necessary ribo.object parameter
}
