% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_functions.R
\name{get_coverage}
\alias{get_coverage}
\title{Retrieves the coverage data for a given transcript}
\usage{
get_coverage(
  ribo.object,
  name,
  range.lower = length_min(ribo.object),
  range.upper = length_max(ribo.object),
  length = TRUE,
  tidy = FALSE,
  alias = FALSE,
  compact = TRUE,
  experiment = experiments(ribo.object)
)
}
\arguments{
\item{ribo.object}{A 'Ribo' object}

\item{name}{Transcript Name}

\item{range.lower}{Lower bound of the read length, inclusive}

\item{range.upper}{Upper bound of the read length, inclusive}

\item{length}{Logical value that denotes if the coverage should be summed across read lengths}

\item{tidy}{Logical value denoting whether or not the user wants a tidy format}

\item{alias}{Option to accept the transcript input as aliases/nicknames}

\item{compact}{Option to return a DataFrame with Rle and factor as opposed to a raw data.frame}

\item{experiment}{List of experiments to obtain coverage information on}
}
\value{
An annotated DataFrame or data.frame (if the compact parameter is set to FALSE) of the
coverage information for the provided list of 'experiments' in the 'experiment' parameter. The
returned object will have a length column when the 'length' parameter is set to FALSE, indicating
that the user does not want to sum the count information across the range of read lengths. The
returned data frame has the option of being tidy, and if the 'tidy' parameter is set to TRUE,
a position column will be added. Finally, if the 'alias' parameter is set to TRUE, the alias transcript
name must have been provided at the generation of the ribo object, and the function
will accept this aliased name in the 'transcript' parameter.
}
\description{
The function \code{\link{get_coverage}} generates a DataFrame of coverage
data over the length of a given transcript.
}
\details{
The function \code{\link{get_coverage}} first checks the experiments in the
'experiments' parameter to see if they are present in the .ribo file.
It will then check these experiments for coverage data which is an optional
dataset. As a result, this function safe guards against experiments that
do not have coverage data, but it also, by default, includes all of the
experiments in a file in the experiments' parameter.

The function checks the coverage of one transcript at a time at
each read length from 'range.lower' to 'range.upper', inclusive. However,
the parameter 'length' allows the user to obtain the coverage
information of a transcript across the range of read lengths indicated by
'range.lower' and 'range.upper'.

If the ribo.object is generated with aliases, the 'alias' parameter, if set to TRUE,
allows the user to use the alias of the transcript as the 'name' parameter instead of
the original transcript name.
}
\examples{
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#get the experiments of interest that also contain coverage data
experiments <- c("Hela_1", "Hela_2", "Hela_3", "WT_1")

#the ribo file contains a transcript named 'MYC'
coverage.data <- get_coverage(ribo.object = sample,
                              name = "MYC",
                              range.lower = 2,
                              range.upper = 5,
                              length = TRUE,
                              experiment = experiments)
}
\seealso{
\code{\link{Ribo}} to generate the necessary ribo.object parameter
}
