% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5S.R
\name{H5Scombine_hyperslab}
\alias{H5Scombine_hyperslab}
\title{Perform operation between an existing selection and an another
hyperslab definition.}
\usage{
H5Scombine_hyperslab(
  h5space,
  op = h5default("H5S_SELECT"),
  start = NULL,
  stride = NULL,
  count = NULL,
  block = NULL
)
}
\arguments{
\item{h5space}{\linkS4class{H5IdComponent} object representing a dataspace.}

\item{op}{Character string defined the operation used to join the two
dataspaces.  See \code{h5const("H5S_SELECT")} for the list of available options.}

\item{start, stride, count, block}{Integer vectors, each with length equal
to the rank of the dataspace.  These parameters define the new hyperslab
to select.}
}
\value{
An \linkS4class{H5IdComponent} object representing a new dataspace
with the generated selection.
}
\description{
Combines a hyperslab selection specified by \code{start}, \code{stride}, \code{count} and
\code{block} arguments with the current selection for the dataspace
represented by \code{h5space}.
}
\examples{

## create a 1 dimensional dataspace
sid_1 <- H5Screate_simple(dims = 20)

## select a single block of 5 points in sid_1
## this is equivalent to [11:16] in R syntax
H5Sselect_hyperslab(sid_1,
  start = 11, stride = 1,
  block = 5, count = 1
) #

## combine the existing selection with a new
## selection consisting of 2 blocks each of 1 point
## equivalent to [c(3,5)] in R syntax
sid_2 <- H5Scombine_hyperslab(sid_1,
  op = "H5S_SELECT_OR",
  start = 3, stride = 2,
  block = 1, count = 2
)

## confirm we have selected 5 in our original dataspace
## and 7 points in the newly created dataspace
H5Sget_select_npoints(sid_1)
H5Sget_select_npoints(sid_2)

## tidy up
H5Sclose(sid_1)
H5Sclose(sid_2)

}
\seealso{
\code{\link[=H5Scombine_select]{H5Scombine_select()}}, \code{\link[=H5Sselect_hyperslab]{H5Sselect_hyperslab()}}
}
