% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Function to draw a Volcano Plot}
\usage{
volcano_plot(
  pval,
  fc,
  names,
  size = 2,
  tFC = 2,
  tPV = -log10(0.001),
  show.effect = FALSE
)
}
\arguments{
\item{pval}{numeric vector of P.Values}

\item{fc}{numeric vector of fold change}

\item{names}{character vector with the feature's names.}

\item{size}{(default \code{2}) Sice of the labels in case they are
placed.}

\item{tFC}{(default \code{2}) fold change threshold. It can be set to
\code{NULL} to do not filter.}

\item{tPV}{(default \code{-log10(0.001)}) P-Value threshold. It can be set
to \code{NULL} to not filter.}

\item{show.effect}{(default \code{FALSE}) If set to \code{TRUE}, the X-axis
will should \code{2^logFC} instead to teh default \code{logFC}.}
}
\value{
A \code{ggplot} object
}
\description{
Function that takes two numeric vectors (P-Value and fold change)
and draws a volcano plot using \link{ggplot2}
}
\examples{
data(exposome)
w1 <- extract(exwas(expo[1:20, ], asthma~1, family = "binomial"))
volcano_plot(w1$pvalue, w1$effect, rownames(w1))
}
