% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{tableLOD}
\alias{tableLOD}
\title{It creates a vector with the amount of under-LOD exposures in an ExposomeSet}
\usage{
tableLOD(object, output = "n", lod.col = "LOD", sort = TRUE)
}
\arguments{
\item{object}{\link{ExposomeSet} which exposome will be plotted.}

\item{output}{(default \code{"n"}) Can be \code{"n"} for number of values,
and \code{"p"} for percentage.}

\item{lod.col}{(default \code{"LOD"}) Name of the column in \code{fData}
containing the LOD thresholds.}

\item{sort}{(default \code{TRUE}) If \code{TRUE} the chart will be ordered
from the features with less missing data to the ones with more under-LOD
values.}
}
\value{
A numeric vector with number of udner-LOD values per exposure. The
vector is labeled with the exposure's names.
}
\description{
This function can be used to obtain a table with the under-LOD data in
exposures of an \link{ExposomeSet}.
}
\examples{
data("exposome")
# The included has no missing data
tableLOD(expo, output = "n")
}
\seealso{
\link{plotFamily} to draw the profile of a family of exposures,
\link{plotHistogram} to draw the shape of an exposure,
\link{plotMissings} to draw a plot with the missing data an ExposomeSet,
\link{imputation} to impute missing data on the exposures of an ExposomeSet
}
