% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotEXP}
\alias{plotEXP}
\title{Plot correlation between exposures and PCA}
\usage{
plotEXP(object, exposure)
}
\arguments{
\item{object}{An object of class \link{ExposomePCA}}

\item{exposure}{(optional) to select a set of exposures to be ploted.
If not given all are used.}
}
\value{
An object of class \code{ggplot}.
}
\description{
Function used to plot the correlation between the exposures in an
\link{ExposomePCA} and the values for each component of the PCA in the
same \link{ExposomePCA}
}
\examples{
data("exposome")
epca <- pca(expo[3:7, 1:100])
plotEXP(epca)
}
\seealso{
\link{pca} to compute PCA on an \link{ExposomeSet}, \link{plotPHE}
to plot the P-Value of association between phenotypes ans PCA,
\link{ExposomePCA} as main class
}
