% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{mexwas}
\alias{mexwas}
\title{Testing the association between an exposure and a phenotype of an
ExposomeSet using a multivariate aproach.}
\usage{
mexwas(object, phenotype, family, warnings = TRUE)
}
\arguments{
\item{object}{\code{ExposomeSet} that will be used for the ExWAS.}

\item{phenotype}{Target phenotype used for the study. If missing all the
phenotypes in the \link{ExposomeSet} will be used.}

\item{family}{It must decrive the nature of the outcome. Can take values
\code{"gaussian"}, \code{"binomial"}, \code{"poisson"}, \code{"multinomial"},
\code{"cox"} or \code{"mgaussian"}.}

\item{warnings}{(default \code{TRUE}) If set to \code{FALSE} warnings will
not be displayed.}
}
\value{
Returns an object of class \link{mExWAS}
}
\description{
The \code{mexwas} method performs an "Multi Exposome-Wide
Association Study" (m-ExWAS) using the exposures in \link{ExposomeSet}
and one of its phenotype. It uses the packages \code{glmnet} and
\code{partDSA}.
}
\examples{
data("exposome")
wt <- mexwas(expo[3:7, 1:100], phenotype = "asthma", family = "binomial")
}
\seealso{
\link{extract} to obtain a table with the result of the ExWAS,
\link{plotExwas} to plot the results of the ExWAS
}
