% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadExposome.R
\name{loadExposome}
\alias{loadExposome}
\title{Creation of an ExposomeSet from \code{data.frames}}
\usage{
loadExposome(
  exposures,
  description,
  phenotype,
  description.famCol = "family",
  exposures.asFactor = 5,
  warnings = TRUE
)
}
\arguments{
\item{exposures}{\code{data.frame} of exposures.}

\item{description}{\code{data.frame} with the description of the exposures
(relation between exposures and exposure-family).}

\item{phenotype}{\code{data.frame} with the phenotypes of interest.}

\item{description.famCol}{(default \code{"family"}) Index where the family's
name (per exposures) if found in file "description". It can be both numeric
or character.}

\item{exposures.asFactor}{(default \code{5}) The exposures with more
than this number of unique items will be considered as "continuous" while
the exposures with less or equal number of items will be considered as
"factor".}

\item{warnings}{(default \code{TRUE}) If \code{TRUE} shows useful
information/warnings from the process of loading the exposome.}
}
\value{
An object of class \link{ExposomeSet}.
}
\description{
Given three \code{data.frames} that defines the exposome (measures
of exposome, exposome description and individuals phentype) it loads
them and creates an object of type \link{ExposomeSet}.
}
\details{
The rows of the exposure's \code{data.frames}, that corresponds to samples'
names, must be the same than the phenotype's \code{data.frames}. In the
same way, the columns in exposure's \code{data.frames} must be the same
in description \code{data.frame}.
}
\note{
\link{ExposomeSet}'s \code{fData} will contain some inner columns
called \code{.std}, \code{.trn}, \code{.fct} and \code{.type} in order to
trace the transformations an exposure suffers and to know, at eny moment, if
an exposure is categorical or continuous. The "description" file can
contains a column called \code{type} with values \code{"factor"} and
\code{"numeric"} to speficy how an exposure needs to be understood. If
given, this column will be renamed to \code{.type}. If not given, it will
be created using \code{exposures.asFactor} value.
}
\examples{
path <- file.path(path.package("rexposome"), "extdata")
description <- file.path(path, "description.csv")
phenotype <- file.path(path, "phenotypes.csv")
exposures <- file.path(path, "exposures.csv")
dd <- read.csv(description, header=TRUE)
ee <- read.csv(exposures, header=TRUE)
pp <- read.csv(phenotype, header=TRUE)
rownames(dd) <- dd[, 2]
dd <- dd[ , -2]
rownames(ee) <- ee[ , 1]
ee <- ee[ , -1]
rownames(pp) <- pp[ , 1]
pp <- pp[ , -1]
exp <- loadExposome(
exposures = ee,
description = dd,
phenotype = pp,
description.famCol = "Family"
)
}
\seealso{
\link{ExposomeSet} for class description,
\link{readExposome} for constructor from txt/csv
files.
}
