% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeLOD.R
\name{imputeLOD}
\alias{imputeLOD}
\title{Function to impute values under limit of detection}
\usage{
imputeLOD(
  x,
  lod,
  description = NULL,
  pNA = 0.2,
  pLOD = 0,
  log = TRUE,
  seed = NULL
)
}
\arguments{
\item{x}{\code{data.frame} containing the exposures as columns and the
samples as rows.}

\item{lod}{\code{vectro} containing the}

\item{description}{\code{1} means values under LOD while \code{2} means
quantifiable value, \code{3}}

\item{pNA}{(default: \code{0.2}) maximum percentage of allowed missing data}

\item{pLOD}{(default: \code{0}) minimum percentave of values under LOD}

\item{log}{(default: \code{NA}) log transformation to normalize data}

\item{seed}{(default: \code{NULL})}
}
\value{
A new \code{data.frame} with the imputed exposures.
}
\description{
Homologous function to the \link{ilod} method of \link{ExposomeSet} for a
given \code{data.frame} of exposures and a \code{vector} of threshold.
The use of this function is related to HELIX Project.
}
\examples{
\dontrun{
inma.imp <- imputeLOD(x = raw, lod = lod, description = desc,
     pNA = pNA, pLOD = pLOD, log = log, seed = seed)
}
}
