% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{highAndLow}
\alias{highAndLow}
\title{Function to convert continuous exposures to categorical exposures}
\usage{
highAndLow(
  object,
  ngroups = 3,
  intervals = "standard",
  select,
  drop = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{object}{An object of class \code{ExposomeSet}.}

\item{ngroups}{(default \code{3}) Number of intervals to be created.}

\item{intervals}{(default \code{"standard"}) If set to \code{"sctandard"}
all levels are set. If set to \code{"extreme"} obly lowes and highest levels
are kept (others are set to \code{NA}).}

\item{select}{(optional) Subset of exposures where the discretization is
applied. If missing, all exposures are used.}

\item{drop}{(default \code{FALSE}) If set to \code{FALSE} original exposures
are kept and discretized exposures are add to \code{ExposomeSet}. If set to
\code{TRUE}, original exposures are replaced by categorical exposures.}

\item{warnings}{(defaulr \code{TRUE}) If set to \code{FALSE} warnings are
not shown.}
}
\value{
A new \code{ExposomeSet} with categorical exposures.
}
\description{
This method allows to convert continuous exposures of an \code{ExposomeSet}
to categorical exposures using the n-percentile groups, defined by
\code{ngroups} argument. By default, all levels are kept but if
\code{intervals} is set to \code{"extrem"}, the levels between the extrems
(aka. lowes and highest) are discarted and their values set to \code{NA}.
}
\examples{
# No drop
data("exposome")
exp.hl <- highAndLow(expo, intervals = "standard", select = "ldde_lip")
dim(exp.hl)
# exposures   samples phenotyes
#       105      1200         4
dim(expo)
# exposures   samples phenotyes
#       104      1200         4
# exps.hl has 107 exposures: the original 104 plus the new
#         3 factored exposures

# Drop
exp.hl <- highAndLow(expo, intervals = "standard",
    select = "ldde_lip", drop = TRUE)
dim(exp.hl)
# exposures   samples phenotyes
#       104      1200         4
dim(expo)
# exposures   samples phenotyes
#       104      1200         4
}
\seealso{
\code{\link{trans}} to transform exposures,
\code{\link{standardize}} to standardize exposures.
}
