% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{correlation}
\alias{correlation}
\title{Creation of an ExposomeCorr from an ExposomeSet.}
\usage{
correlation(object, ..., warnings = TRUE)
}
\arguments{
\item{object}{\code{ExposomeSet} which exposures will be used to calculate
their correlation}

\item{...}{Other arguments passed to \link{cor}, \link{cramersV} or
to \link{lm}.}

\item{warnings}{(default \code{TRUE}) If set to \code{FALSE} warnings will
not be displayed.}
}
\value{
\code{ExposomeCorr} with the correlation between the selected
exposures and their description
}
\description{
Method to calculate the correlation between the exposures of an
\link{ExposomeSet}. The correlation method takes into account the 
nature of each pair of exposures: continuous vs. continuous uses 
cor function from R base, categorical vs. categorical uses 
cramerV function from lsr R package and categorical vs. continuous 
exposures correlation is calculated as the square root of 
the adjusted r-square obtained from fitting a lineal model with 
the categorical exposures as dependent variable and the continuous 
exposure as independent variable. The function creates and returns 
an \link{ExposomeCorr} object.
}
\examples{
data("exposome")
expo.c <- correlation(expo)
expo.c
expo.c.table <- extract(expo.c)
}
\seealso{
\link{plotCorrelation} to plot the correlations of an
\link{ExposomeCorr}, \link{clustering} to see how the exposures can
cluster samples, \link{pca} to compute PCA on exposures
}
