% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/ExposomePCA-exposureNames.R, R/ExposomePCA-extract.R,
%   R/ExposomePCA-ndim.R, R/ExposomePCA-phenotypeNames.R,
%   R/ExposomePCA-plot3PCA.R, R/ExposomePCA-plotEXP.R, R/ExposomePCA-plotPCA.R,
%   R/ExposomePCA-plotPHE.R
\docType{class}
\name{ExposomePCA}
\alias{ExposomePCA}
\alias{ExposomePCA-class}
\alias{plot,ExposomePCA,ANY-method}
\alias{exposureNames,ExposomePCA-method}
\alias{extract,ExposomePCA-method}
\alias{ndim,ExposomePCA-method}
\alias{phenotypeNames,ExposomePCA-method}
\alias{plot3PCA,ExposomePCA-method}
\alias{plotEXP,ExposomePCA-method}
\alias{plotPCA,ExposomePCA-method}
\alias{plotPHE,ExposomePCA-method}
\title{Class ExposomePCA}
\usage{
\S4method{plot}{ExposomePCA,ANY}(x, y, ...)

\S4method{exposureNames}{ExposomePCA}(object)

\S4method{extract}{ExposomePCA}(object, table = "exposures", ...)

\S4method{ndim}{ExposomePCA}(object)

\S4method{phenotypeNames}{ExposomePCA}(object)

\S4method{plot3PCA}{ExposomePCA}(
  object,
  cmpX,
  cmpY,
  cmpZ,
  phenotype,
  main,
  angle = 35,
  pch = 16,
  legend = TRUE,
  plines = TRUE
)

\S4method{plotEXP}{ExposomePCA}(object, exposure)

\S4method{plotPCA}{ExposomePCA}(
  object,
  set,
  cmpX = 1,
  cmpY = 2,
  show.exposures = FALSE,
  show.samples = FALSE,
  phenotype
)

\S4method{plotPHE}{ExposomePCA}(object, phenotype, exp2fac = 5)
}
\arguments{
\item{x}{Object of class \code{ExposomePCA}}

\item{y}{NOT USED}

\item{...}{NOT USED}

\item{object}{An \code{\link{ExposomePCA}} object}

\item{table}{Can takes values \code{"exposures"} or \code{"individuals"}.}

\item{cmpX}{PC to place in X-axis}

\item{cmpY}{PC to place in Y-axis}

\item{cmpZ}{PC to place in Z-axis}

\item{phenotype}{(when \code{set="samples"}) A phenotype can be selected
so the samples are coloured by its value.}

\item{main}{Title}

\item{angle}{Point of view}

\item{pch}{Size of the dots}

\item{legend}{Boolean to show or hide the legend}

\item{plines}{Boolean to show of hide the dotted lines that helps to place
the dots in the X/Y axes}

\item{exposure}{Vector of exposures to be shown in the plot}

\item{set}{Can take values \code{"exposures"}, \code{"samples"} or
\code{"all"}}

\item{show.exposures}{When set to \code{TRUE}, labels for exposures are shown}

\item{show.samples}{When set to \code{TRUE}, labels for samples are shown}

\item{exp2fac}{Number of different values to considere an exposures
continuous}
}
\value{
An object of class \code{ExposomePCA}
}
\description{
Class \code{ExposomePCA} contains a matrix of exposures used to
compute the PCA, also a table of phenotypes and a set congtaing the
multiple results of computing the PCA.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = ExposomePCA, y = ANY)}: Wrapper for \code{plotPCA} method.

\item \code{exposureNames(ExposomePCA)}: Getter to obtain the exposures's names.

\item \code{extract(ExposomePCA)}: Method to extract the raw results of the PCA.

\item \code{ndim(ExposomePCA)}: Number of principal components in an ExposomePCA.

\item \code{phenotypeNames(ExposomePCA)}: Getter to obtain the phenotype's names.

\item \code{plot3PCA(ExposomePCA)}: Methdo to draw a 3D plot for PCA

\item \code{plotEXP(ExposomePCA)}: Plot correlation between exposures and PCA

\item \code{plotPCA(ExposomePCA)}: Methdo to draw a 2D plot for PCA

\item \code{plotPHE(ExposomePCA)}: Plot association score between phentoypes and PCA

}}
\section{Slots}{

\describe{
\item{\code{pca}}{list containing all elements of the PCA}

\item{\code{phenoData}}{Contains the phenotypes or variables experimenter-supplied
(see \link{eSet}, \link{AnnotatedDataFrame}).}

\item{\code{featureData}}{Contains the description of the exposures including
the family where they belong (see \link{eSet}, \link{AnnotatedDataFrame}).}
}}

\seealso{
\code{\link{correlation}} to study the correlation between
exposures in a \code{\link{ExposomeSet}}
}
