% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/ExposomeCorr-dim.R, R/ExposomeCorr-extract.R,
%   R/ExposomeCorr-plotCorrelation.R
\docType{class}
\name{ExposomeCorr}
\alias{ExposomeCorr}
\alias{ExposomeCorr-class}
\alias{plot,ExposomeCorr,ANY-method}
\alias{dim,ExposomeCorr-method}
\alias{extract,ExposomeCorr-method}
\alias{plotCorrelation,ExposomeCorr-method}
\title{Class ExposomeCorr}
\usage{
\S4method{plot}{ExposomeCorr,ANY}(x, y, ...)

\S4method{dim}{ExposomeCorr}(x)

\S4method{extract}{ExposomeCorr}(object, sort, ...)

\S4method{plotCorrelation}{ExposomeCorr}(object, type = c("circos", "matrix"), ...)
}
\arguments{
\item{x}{Object of class \link{ExposomeCorr}}

\item{y}{NOT USED}

\item{...}{Arguments passed to \code{corrplot} when \code{type="matrix"}.}

\item{object}{An \code{\link{ExposomeCorr}} object.}

\item{sort}{NOT USED}

\item{type}{To choose between \code{"circos"} and \code{"matrix"}.}
}
\value{
An object of class \code{ExposomeCorr}
}
\description{
Class \code{ExposomeCorr} contains a matrix of correlations between
continuos exposures calculated using \link{cor}. It also contains the
description of each exposures (\code{fData} of the original
\link{ExposomeSet}) in order to maintain a coherence
with the original source. It extends \link{eSet-class}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = ExposomeCorr, y = ANY)}: Wrapper for \code{plotClassification} method.

\item \code{dim(ExposomeCorr)}: Return the dimension of the internat matrix of
correlation.

\item \code{extract(ExposomeCorr)}: Return the raw correlation matrix

\item \code{plotCorrelation(ExposomeCorr)}: Draws both a matrix of circos plot of correlations

}}
\section{Slots}{

\describe{
\item{\code{assayData}}{Contains the correlation matrix
(see \link{eSet}, \link{AssayData}).}

\item{\code{featureData}}{Contains the description of the exposures including
the family where they belong (see \link{eSet}, \link{AnnotatedDataFrame}).}
}}

\seealso{
\code{\link{pca}} to study the behavioud between samples
and exposures in an \code{\link{ExposomeSet}}
}
