% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateWithCorrelations.R
\name{annotateWithCorrelations}
\alias{annotateWithCorrelations}
\title{RETROFIT matching algorithm}
\usage{
annotateWithCorrelations(sc_ref, K, decomp_w, decomp_h)
}
\arguments{
\item{sc_ref}{A Matrix or Array with two dimensions (GeneExpressions, Cell types).}

\item{K}{integer: The number of cell types to be selected}

\item{decomp_w}{Matrix(GeneExpressions, Components): Decomposed w matrix}

\item{decomp_h}{Matrix(Components, Spots): Decomposed h matrix}
}
\value{
A list of selected components, cells, and correlations
\itemize{
\item w:  Filtered 2d array with GeneExpressions, Cell types
\item h:  Filtered2d array with Cell types, Spots
\item ranked_cells: The list of cell names
\item ranked_correlations: The list of correlations
}
}
\description{
Match cell types based on correlations with reference. decomp_w   between matching algorithm description
}
\examples{
data("testSimulationData")
K            = 10
sc_ref       = testSimulationData$sc_ref
W            = testSimulationData$decompose$w
H            = testSimulationData$decompose$h

result       = retrofit::annotateWithCorrelations(sc_ref=sc_ref, K=K, 
                                                 decomp_w=W, decomp_h=H)
H_annotated  = result$h                                              
W_annotated  = result$w
ranked_cells = result$ranked_cells
}
\seealso{
papers reference
}
