% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_attributes.R
\name{list_attributes}
\alias{list_attributes}
\title{List attributes/fields from a dataset/table}
\usage{
list_attributes(regulondb, dataset)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{dataset}{Dataset of interest. The name should correspond to a table of
the database.}
}
\value{
A character vector with the field names.
}
\description{
List all attributes and their description of a dataset from
RegulonDB. The result of this function may
be used as parameter 'values' in \code{\link[=list_attributes]{list_attributes()}} function.
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## List the transcription factor attributes
list_attributes(e_coli_regulondb, "TF")

## List the operon attributes
list_attributes(e_coli_regulondb, "OPERON")
}
\author{
Carmina Barberena Jonás, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chavez
}
\keyword{attributes}
\keyword{data}
\keyword{retrieval,}
