% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_regulatory_network.R
\name{get_regulatory_network}
\alias{get_regulatory_network}
\title{Return complete regulatory network.}
\usage{
get_regulatory_network(
  regulondb,
  regulator = NULL,
  type = "TF-GENE",
  cytograph = FALSE
)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{regulator}{Name of TF or gene that acts as regulator. If \code{NULL}, the
function retrieves all existent networks in the regulonDB.}

\item{type}{"TF-GENE", "TF-TF", "GENE-GENE"}

\item{cytograph}{If TRUE, displays network in Cytoscape. This option
requires previous instalation and launch of Cytoscape.}
}
\value{
A \link[=regulondb_result-class]{regulondb_result} object.
}
\description{
This function retrieves all the regulation networks in
regulonDB between TF-TF, GENE-GENE or TF-GENE depending on the parameter
'type'.
}
\examples{

## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Retrieve regulation of 'araC'
get_regulatory_network(e_coli_regulondb,
    regulator = "AraC",
    type = "TF-GENE"
)

## Retrieve all GENE-GENE networks
get_regulatory_network(e_coli_regulondb, type = "GENE-GENE")

## Retrieve TF-GENE network of AraC and display in Cytoscape
## Note that Cytospace needs to be open for this to work
cytoscape_present <- try(RCy3::cytoscapePing(), silent = TRUE)
if (!is(cytoscape_present, "try-error")) {
    get_regulatory_network(
        e_coli_regulondb,
        regulator = "AraC",
        type = "TF-GENE",
        cytograph = TRUE
    )
}
}
\author{
Carmina Barberena Jonas, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chávez
}
\keyword{TF,}
\keyword{networks,}
\keyword{regulation}
\keyword{retrieval,}
