% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gene_regulators.R
\name{get_gene_regulators}
\alias{get_gene_regulators}
\title{Get TFs or genes that regulate the genes of interest}
\usage{
get_gene_regulators(regulondb, genes, format = "multirow", output.type = "TF")
}
\arguments{
\item{regulondb}{A regulondb class.}

\item{genes}{Vector of genes (name, bnumber or GI).}

\item{format}{Output format: multirow, onerow, table}

\item{output.type}{How regulators will be represented: "TF"/"GENE"}
}
\value{
A \link[=regulondb_result-class]{regulondb_result} object.
}
\description{
Given a list of genes (name, bnumber or GI),
get all transcription factors or genes that regulate them.
The effect of regulators over the gene of interest can be positive (+),
negative (-) or dual (+/-)
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Get Transcription factors that regulate araC in one row
get_gene_regulators(
    e_coli_regulondb,
    genes = c("araC"),
    output.type = "TF",
    format = "onerow"
)

## Get genes that regulate araC in table format
get_gene_regulators(
    e_coli_regulondb,
    genes = c("araC"),
    output.type = "GENE",
    format = "table"
)
}
\author{
Carmina Barberena Jonas, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chávez
}
\keyword{TFs,}
\keyword{networks,}
\keyword{regulation}
\keyword{retrieval,}
