% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterLowCounts.R
\name{filterLowCounts}
\alias{filterLowCounts}
\title{Filter low-count exons.}
\usage{
filterLowCounts(rs_data, filter_min_per_exon = 6, filter_min_per_sample = 3)
}
\arguments{
\item{rs_data}{\code{\linkS4class{RegspliceData}} object.}

\item{filter_min_per_exon}{Filtering parameter: minimum number of reads per exon bin, 
summed across all biological samples. Default is 6.}

\item{filter_min_per_sample}{Filtering parameter: minimum number of reads per 
biological sample; i.e. for each exon bin, at least one sample must have this number
of reads. Default is 3.}
}
\value{
Returns a \code{\linkS4class{RegspliceData}} object.
}
\description{
Filter low-count exons from RNA-seq read count data.
}
\details{
Filters low-count exon bins from RNA-seq read count data. Any remaining single-exon 
genes (after filtering) are also removed (since differential splicing requires
multiple exon bins).

Input data is assumed to be in the form of a \code{RegspliceData} object. See 
\code{\link{RegspliceData}} for details.

The arguments \code{filter_min_per_exon} and \code{filter_min_per_sample} control the 
amount of filtering. Exon bins that meet the filtering conditions are kept. Default 
values for the arguments are provided; however, these should be adjusted depending on 
the total number of samples and the number of samples per condition.

After filtering low-count exon bins, any remaining genes containing only a single exon
bin are also removed (since differential splicing requires multiple exon bins).

Filtering should be skipped when using exon microarray data. (When using the 
\code{regsplice} wrapper function, filtering can be disabled with the argument 
\code{filter = FALSE}).

Previous step: Filter zero-count exon bins with \code{\link{filterZeros}}.
Next step: Calculate normalization factors with \code{\link{runNormalization}}.
}
\examples{
file_counts <- system.file("extdata/vignette_counts.txt", package = "regsplice")
data <- read.table(file_counts, header = TRUE, sep = "\t", stringsAsFactors = FALSE)
head(data)

counts <- data[, 2:7]
tbl_exons <- table(sapply(strsplit(data$exon, ":"), function(s) s[[1]]))
gene_IDs <- names(tbl_exons)
n_exons <- unname(tbl_exons)
condition <- rep(c("untreated", "treated"), each = 3)

rs_data <- RegspliceData(counts, gene_IDs, n_exons, condition)

rs_data <- filterZeros(rs_data)
rs_data <- filterLowCounts(rs_data)

}
\seealso{
\code{\link{filterZeros}} \code{\link{runNormalization}}
}
