% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLocalZscore.R
\name{multiLocalZscore}
\alias{multiLocalZscore}
\title{multiLocalZscore}
\usage{
multiLocalZscore(A, Blist = NULL, sampling = FALSE, fraction = 0.15,
min_sampling = 5000, ranFUN = "randomizeRegions", evFUN = "numOverlaps",
ntimes = 100, adj_pv_method = "BH", genome = "hg19", universe = NULL,
window = 1000, step = 100, ...)
}
\arguments{
\item{A}{query region set for which to estimate local z-score values.}

\item{Blist}{\link[GenomicRanges:GRangesList-class]{GRangesList} or list of region sets in any accepted formats by \href{https://bioconductor.org/packages/release/bioc/html/regioneR.html}{regioneR} package
(\link[GenomicRanges:GRanges-class]{GRanges}, \link{data.frame} etc.).}

\item{sampling}{logical, if TRUE the function will use only a sample of each element of Alist to perform the test as specified in \code{fraction.} (default = FALSE)}

\item{fraction}{logical, if \code{sampling=TRUE}, defines the fraction of the region sets used to perform the test. (default = 0.15)}

\item{min_sampling}{numeric, minimum number of regions accepted after sampling is performed with the specified \code{fraction}. If the number of sampled
regions is less than \code{min_sampling}, the number specified by \code{min_sampling} will be used as number of regions sampled instead. (default = 5000)}

\item{ranFUN}{character, the randomization strategy used for the test, see \href{https://bioconductor.org/packages/release/bioc/html/regioneR.html}{regioneR}. (default = "randomizeRegions")}

\item{evFUN}{character, the evaluation strategy used for the test, see  \href{https://bioconductor.org/packages/release/bioc/html/regioneR.html}{regioneR}. (default = "numOverlaps)}

\item{ntimes}{numeric, number of permutations used in the test. (default = 100)}

\item{adj_pv_method}{character, the method used for the calculation of the adjusted p-value, to choose between the options of \code{\link[=p.adjust]{p.adjust()}}. (default = "BH")}

\item{genome}{character or \link[GenomicRanges:GRanges-class]{GRanges}, genome used to compute the randomization. (default = "hg19")}

\item{universe}{region set to use as universe, used only when \code{\link[regioneR:resampleRegions]{regioneR::resampleRegions()}} function is selected. (default = NULL)}

\item{window}{numeric, window (number of base pairs) in which the local z-score will be calculated. (default = 1000)}

\item{step}{numeric, step (number of base pairs) by which will be estimated the local Z-score. (default = 100)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
A object of class \link[=multiLocalZScore-class]{multiLocalZScore} containing three slots

\itemize{
\item \bold{\code{@parameters}}
\item \bold{\code{@multiLocalZscores}}
\item \bold{\code{@matrix}}

}
}
\description{
Perform multiple permutation tests between a region set and each element in
a list of region sets using shifted positions to calculate a local z-score.
}
\details{
This function performs multiple permutation tests between a single region set
and each element in a list of region sets. For every pairwise combination, the
evaluation step is repeated each time shifting the position of all the regions in the query region set
by a fixed step inside a defined window (using \code{\link[regioneR:localZScore]{regioneR::localZScore()}}.
This produces a "local z-score" profile that can be indicative of the nature
of the association between region sets. For example, an association can occur
"centrally" if the z-score value drops sharply when sifting the region set.
On the other hand, two region sets may have a peak of local z-score away from
the central position if they happen to occur often at a regular distance,
showing a "lateral" association.
}
\examples{

fakeGenome<- regioneR::toGRanges("chrF",1,1000)
regA <- regioneR::createRandomRegions(nregions = 10, length.mean = 10,
length.sd = 2,genome = fakeGenome)
regB <- regioneR::createRandomRegions(nregions = 10,length.mean = 10,
length.sd = 2,genome = fakeGenome)
regAs <-similarRegionSet(GR = regA,genome = fakeGenome, name = "A",
vectorPerc = seq(0.1,0.3,by =0.1))
regBs <-similarRegionSet(GR = regB,genome = fakeGenome, name = "B",
vectorPerc = seq(0.1,0.3,by =0.1))
ABList <- c(regAs,regBs)

mlz_ptAB <- multiLocalZscore(A = regA, Blist = ABList,
genome = fakeGenome, ntimes = 10)
summary(mlz_ptAB)


}
\seealso{
\code{\link[regioneR:localZScore]{regioneR::localZScore()}}
}
