% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqueRegions.R
\name{uniqueRegions}
\alias{uniqueRegions}
\title{Unique Regions}
\usage{
uniqueRegions(A, B)
}
\arguments{
\item{A}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{B}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}
}
\value{
It returns a \code{\link{GenomicRanges}} object with the regions unique to one of the region sets.
}
\description{
Returns the regions unique to only one of the two region sets, that is, all parts of the genome covered by only one of the two region sets.
}
\note{
All metadata (additional columns in the region set in addition to chromosome, start and end) will be ignored and not present in the returned region set.
}
\examples{
A <- data.frame("chr1", c(1, 10, 20, 30), c(12, 13, 28, 40))

B <- data.frame("chr1", 25, 35)

uniques <- uniqueRegions(A, B)

plotRegions(list(A, B, uniques), chromosome="chr1", regions.labels=c("A", "B", "uniques"), regions.colors=3:1)

}
\seealso{
\code{\link{toGRanges}}, \code{\link{subtractRegions}}, \code{\link{commonRegions}}, \code{\link{mergeRegions}}
}
