% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampleGenome.R
\name{resampleGenome}
\alias{resampleGenome}
\title{resampleGenome}
\usage{
resampleGenome(A, simple = FALSE, per.chromosome = FALSE, genome="hg19", min.tile.width=1000, ...)
}
\arguments{
\item{A}{an object of class GenomigRanges}

\item{simple}{logical, if TRUE the randomization process will not take into account the specific width of each region in A. (defalut = FALSE)}

\item{per.chromosome}{logical, if TRUE the randomization will be perform by chromosome. (default  = TRUE)}

\item{genome}{character or GenomicRanges, genome using for the randomization}

\item{min.tile.width}{integer, the minimum size of the genome tiles. If they are too small, the functions gets very slow and may even fail to work. (default = 1000, 1kb tiles)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
a \code{\link{GenomicRanges}} object. A sample from the \code{universe} with the same length as A.
}
\description{
Fast alternative to randomizeRegions. It creates a tiling (binning) of the whole genome 
with tiles the mean size of the regions in A and then places the regions by sampling a 
length(A) number of tiles and placing the resampled regions there.
}
\examples{

A <- data.frame(chr=1, start=c(2,12,28,35), end=c(5,25,33,43))

B <- resampleGenome(A)
B
width(B)

B2 <- resampleGenome(A, simple=TRUE)
B2
width(B2)

resampleGenome(A, per.chromosome=TRUE)


}
\seealso{
\code{\link{toDataframe}}, \code{\link{toGRanges}}, \code{\link{randomizeRegions}}, \code{\link{createRandomRegions}}
}
